<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLoadInfo StructType
 * @subpackage Structs
 */
class VehicleLoadInfo extends AbstractStructBase
{
    /**
     * The LoadCapacityWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LoadCapacityWeight;
    /**
     * The LoadCapacityVolumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadCapacityVolumn;
    /**
     * The LoadHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadHeight;
    /**
     * The LoadLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadLength;
    /**
     * The LoadWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadWidth;
    /**
     * The MaxAllowedMass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxAllowedMass;
    /**
     * Constructor method for VehicleLoadInfo
     * @uses VehicleLoadInfo::setLoadCapacityWeight()
     * @uses VehicleLoadInfo::setLoadCapacityVolumn()
     * @uses VehicleLoadInfo::setLoadHeight()
     * @uses VehicleLoadInfo::setLoadLength()
     * @uses VehicleLoadInfo::setLoadWidth()
     * @uses VehicleLoadInfo::setMaxAllowedMass()
     * @param int $loadCapacityWeight
     * @param float $loadCapacityVolumn
     * @param float $loadHeight
     * @param float $loadLength
     * @param float $loadWidth
     * @param int $maxAllowedMass
     */
    public function __construct($loadCapacityWeight = null, $loadCapacityVolumn = null, $loadHeight = null, $loadLength = null, $loadWidth = null, $maxAllowedMass = null)
    {
        $this
            ->setLoadCapacityWeight($loadCapacityWeight)
            ->setLoadCapacityVolumn($loadCapacityVolumn)
            ->setLoadHeight($loadHeight)
            ->setLoadLength($loadLength)
            ->setLoadWidth($loadWidth)
            ->setMaxAllowedMass($maxAllowedMass);
    }
    /**
     * Get LoadCapacityWeight value
     * @return int
     */
    public function getLoadCapacityWeight()
    {
        return $this->LoadCapacityWeight;
    }
    /**
     * Set LoadCapacityWeight value
     * @param int $loadCapacityWeight
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadCapacityWeight($loadCapacityWeight = null)
    {
        // validation for constraint: int
        if (!is_null($loadCapacityWeight) && !(is_int($loadCapacityWeight) || ctype_digit($loadCapacityWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loadCapacityWeight, true), gettype($loadCapacityWeight)), __LINE__);
        }
        $this->LoadCapacityWeight = $loadCapacityWeight;
        return $this;
    }
    /**
     * Get LoadCapacityVolumn value
     * @return float
     */
    public function getLoadCapacityVolumn()
    {
        return $this->LoadCapacityVolumn;
    }
    /**
     * Set LoadCapacityVolumn value
     * @param float $loadCapacityVolumn
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadCapacityVolumn($loadCapacityVolumn = null)
    {
        // validation for constraint: float
        if (!is_null($loadCapacityVolumn) && !(is_float($loadCapacityVolumn) || is_numeric($loadCapacityVolumn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadCapacityVolumn, true), gettype($loadCapacityVolumn)), __LINE__);
        }
        $this->LoadCapacityVolumn = $loadCapacityVolumn;
        return $this;
    }
    /**
     * Get LoadHeight value
     * @return float
     */
    public function getLoadHeight()
    {
        return $this->LoadHeight;
    }
    /**
     * Set LoadHeight value
     * @param float $loadHeight
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadHeight($loadHeight = null)
    {
        // validation for constraint: float
        if (!is_null($loadHeight) && !(is_float($loadHeight) || is_numeric($loadHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadHeight, true), gettype($loadHeight)), __LINE__);
        }
        $this->LoadHeight = $loadHeight;
        return $this;
    }
    /**
     * Get LoadLength value
     * @return float
     */
    public function getLoadLength()
    {
        return $this->LoadLength;
    }
    /**
     * Set LoadLength value
     * @param float $loadLength
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadLength($loadLength = null)
    {
        // validation for constraint: float
        if (!is_null($loadLength) && !(is_float($loadLength) || is_numeric($loadLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadLength, true), gettype($loadLength)), __LINE__);
        }
        $this->LoadLength = $loadLength;
        return $this;
    }
    /**
     * Get LoadWidth value
     * @return float
     */
    public function getLoadWidth()
    {
        return $this->LoadWidth;
    }
    /**
     * Set LoadWidth value
     * @param float $loadWidth
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadWidth($loadWidth = null)
    {
        // validation for constraint: float
        if (!is_null($loadWidth) && !(is_float($loadWidth) || is_numeric($loadWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadWidth, true), gettype($loadWidth)), __LINE__);
        }
        $this->LoadWidth = $loadWidth;
        return $this;
    }
    /**
     * Get MaxAllowedMass value
     * @return int
     */
    public function getMaxAllowedMass()
    {
        return $this->MaxAllowedMass;
    }
    /**
     * Set MaxAllowedMass value
     * @param int $maxAllowedMass
     * @return \StructType\VehicleLoadInfo
     */
    public function setMaxAllowedMass($maxAllowedMass = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedMass) && !(is_int($maxAllowedMass) || ctype_digit($maxAllowedMass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedMass, true), gettype($maxAllowedMass)), __LINE__);
        }
        $this->MaxAllowedMass = $maxAllowedMass;
        return $this;
    }
}
