<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleIdentifier StructType
 * @subpackage Structs
 */
class VehicleIdentifier extends AbstractStructBase
{
    /**
     * The TransicsVehicleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsVehicleID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * Constructor method for VehicleIdentifier
     * @uses VehicleIdentifier::setTransicsVehicleID()
     * @uses VehicleIdentifier::setID()
     * @uses VehicleIdentifier::setLicensePlate()
     * @uses VehicleIdentifier::setCode()
     * @param int $transicsVehicleID
     * @param string $iD
     * @param string $licensePlate
     * @param string $code
     */
    public function __construct($transicsVehicleID = null, $iD = null, $licensePlate = null, $code = null)
    {
        $this
            ->setTransicsVehicleID($transicsVehicleID)
            ->setID($iD)
            ->setLicensePlate($licensePlate)
            ->setCode($code);
    }
    /**
     * Get TransicsVehicleID value
     * @return int
     */
    public function getTransicsVehicleID()
    {
        return $this->TransicsVehicleID;
    }
    /**
     * Set TransicsVehicleID value
     * @param int $transicsVehicleID
     * @return \StructType\VehicleIdentifier
     */
    public function setTransicsVehicleID($transicsVehicleID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsVehicleID) && !(is_int($transicsVehicleID) || ctype_digit($transicsVehicleID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsVehicleID, true), gettype($transicsVehicleID)), __LINE__);
        }
        $this->TransicsVehicleID = $transicsVehicleID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VehicleIdentifier
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\VehicleIdentifier
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehicleIdentifier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
