<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleETAInfo_V2 StructType
 * @subpackage Structs
 */
class VehicleETAInfo_V2 extends VehicleETAInfo
{
    /**
     * The EtaRestIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EtaRestIncluded;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * Constructor method for VehicleETAInfo_V2
     * @uses VehicleETAInfo_V2::setEtaRestIncluded()
     * @uses VehicleETAInfo_V2::setPlace()
     * @uses VehicleETAInfo_V2::setTrip()
     * @param string $etaRestIncluded
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     */
    public function __construct($etaRestIncluded = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null)
    {
        $this
            ->setEtaRestIncluded($etaRestIncluded)
            ->setPlace($place)
            ->setTrip($trip);
    }
    /**
     * Get EtaRestIncluded value
     * @return string
     */
    public function getEtaRestIncluded()
    {
        return $this->EtaRestIncluded;
    }
    /**
     * Set EtaRestIncluded value
     * @param string $etaRestIncluded
     * @return \StructType\VehicleETAInfo_V2
     */
    public function setEtaRestIncluded($etaRestIncluded = null)
    {
        // validation for constraint: string
        if (!is_null($etaRestIncluded) && !is_string($etaRestIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etaRestIncluded, true), gettype($etaRestIncluded)), __LINE__);
        }
        $this->EtaRestIncluded = $etaRestIncluded;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\VehicleETAInfo_V2
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\VehicleETAInfo_V2
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
}
