<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleActivityInfoItem StructType
 * @subpackage Structs
 */
class VehicleActivityInfoItem extends AbstractStructBase
{
    /**
     * The DateTimeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateTimeInfo;
    /**
     * The DateTimeCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateTimeCreated;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Speed;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The ModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ModificationID;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Trailer;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo_with_ActivityStatus
     */
    public $Activity;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for VehicleActivityInfoItem
     * @uses VehicleActivityInfoItem::setDateTimeInfo()
     * @uses VehicleActivityInfoItem::setDateTimeCreated()
     * @uses VehicleActivityInfoItem::setSpeed()
     * @uses VehicleActivityInfoItem::setFuelLevel()
     * @uses VehicleActivityInfoItem::setModificationID()
     * @uses VehicleActivityInfoItem::setDriver()
     * @uses VehicleActivityInfoItem::setCoDriver()
     * @uses VehicleActivityInfoItem::setVehicle()
     * @uses VehicleActivityInfoItem::setTrailer()
     * @uses VehicleActivityInfoItem::setActivity()
     * @uses VehicleActivityInfoItem::setInfo()
     * @uses VehicleActivityInfoItem::setPosition()
     * @param string $dateTimeInfo
     * @param string $dateTimeCreated
     * @param float $speed
     * @param int $fuelLevel
     * @param int $modificationID
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @param \StructType\ActivityInfo_with_ActivityStatus $activity
     * @param string $info
     * @param \StructType\PositionResult $position
     */
    public function __construct($dateTimeInfo = null, $dateTimeCreated = null, $speed = null, $fuelLevel = null, $modificationID = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierVehicleResult_V2 $trailer = null, \StructType\ActivityInfo_with_ActivityStatus $activity = null, $info = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setDateTimeInfo($dateTimeInfo)
            ->setDateTimeCreated($dateTimeCreated)
            ->setSpeed($speed)
            ->setFuelLevel($fuelLevel)
            ->setModificationID($modificationID)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setActivity($activity)
            ->setInfo($info)
            ->setPosition($position);
    }
    /**
     * Get DateTimeInfo value
     * @return string
     */
    public function getDateTimeInfo()
    {
        return $this->DateTimeInfo;
    }
    /**
     * Set DateTimeInfo value
     * @param string $dateTimeInfo
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setDateTimeInfo($dateTimeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeInfo) && !is_string($dateTimeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeInfo, true), gettype($dateTimeInfo)), __LINE__);
        }
        $this->DateTimeInfo = $dateTimeInfo;
        return $this;
    }
    /**
     * Get DateTimeCreated value
     * @return string
     */
    public function getDateTimeCreated()
    {
        return $this->DateTimeCreated;
    }
    /**
     * Set DateTimeCreated value
     * @param string $dateTimeCreated
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setDateTimeCreated($dateTimeCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeCreated) && !is_string($dateTimeCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeCreated, true), gettype($dateTimeCreated)), __LINE__);
        }
        $this->DateTimeCreated = $dateTimeCreated;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: float
        if (!is_null($speed) && !(is_float($speed) || is_numeric($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get ModificationID value
     * @return int
     */
    public function getModificationID()
    {
        return $this->ModificationID;
    }
    /**
     * Set ModificationID value
     * @param int $modificationID
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setModificationID($modificationID = null)
    {
        // validation for constraint: int
        if (!is_null($modificationID) && !(is_int($modificationID) || ctype_digit($modificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationID, true), gettype($modificationID)), __LINE__);
        }
        $this->ModificationID = $modificationID;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo_with_ActivityStatus|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo_with_ActivityStatus $activity
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setActivity(\StructType\ActivityInfo_with_ActivityStatus $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\VehicleActivityInfoItem
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
