<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLatest StructType
 * @subpackage Structs
 */
class UpdateLatest extends ProfileActionStrategySelection
{
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $From;
    /**
     * The Until
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Until;
    /**
     * Constructor method for UpdateLatest
     * @uses UpdateLatest::setProfileType()
     * @uses UpdateLatest::setId()
     * @uses UpdateLatest::setFrom()
     * @uses UpdateLatest::setUntil()
     * @param string $profileType
     * @param int $id
     * @param string $from
     * @param string $until
     */
    public function __construct($profileType = null, $id = null, $from = null, $until = null)
    {
        $this
            ->setProfileType($profileType)
            ->setId($id)
            ->setFrom($from)
            ->setUntil($until);
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumProfileType_V2::valueIsValid()
     * @uses \EnumType\EnumProfileType_V2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\UpdateLatest
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumProfileType_V2::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumProfileType_V2', is_array($profileType) ? implode(', ', $profileType) : var_export($profileType, true), implode(', ', \EnumType\EnumProfileType_V2::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\UpdateLatest
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\UpdateLatest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Until value
     * @return string
     */
    public function getUntil()
    {
        return $this->Until;
    }
    /**
     * Set Until value
     * @param string $until
     * @return \StructType\UpdateLatest
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($until, true), gettype($until)), __LINE__);
        }
        $this->Until = $until;
        return $this;
    }
}
