<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trip_V2 StructType
 * @subpackage Structs
 */
class Trip_V2 extends AbstractStructBase
{
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSequence;
    /**
     * The TripId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripId;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Trip_V2
     * @uses Trip_V2::setExecutionDate()
     * @uses Trip_V2::setOrderSequence()
     * @uses Trip_V2::setTripId()
     * @uses Trip_V2::setDriverDisplay()
     * @uses Trip_V2::setComment()
     * @param string $executionDate
     * @param int $orderSequence
     * @param string $tripId
     * @param string $driverDisplay
     * @param string $comment
     */
    public function __construct($executionDate = null, $orderSequence = null, $tripId = null, $driverDisplay = null, $comment = null)
    {
        $this
            ->setExecutionDate($executionDate)
            ->setOrderSequence($orderSequence)
            ->setTripId($tripId)
            ->setDriverDisplay($driverDisplay)
            ->setComment($comment);
    }
    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }
    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return \StructType\Trip_V2
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        $this->ExecutionDate = $executionDate;
        return $this;
    }
    /**
     * Get OrderSequence value
     * @return int
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\Trip_V2
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Get TripId value
     * @return string|null
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param string $tripId
     * @return \StructType\Trip_V2
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: string
        if (!is_null($tripId) && !is_string($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripId, true), gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Trip_V2
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Trip_V2
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
