<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripReportActivitySummary StructType
 * @subpackage Structs
 */
class TripReportActivitySummary extends Activity
{
    /**
     * The ExecutionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExecutionCount;
    /**
     * The TotalDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDuration;
    /**
     * The TotalDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDistance;
    /**
     * The TotalConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * Constructor method for TripReportActivitySummary
     * @uses TripReportActivitySummary::setExecutionCount()
     * @uses TripReportActivitySummary::setTotalDuration()
     * @uses TripReportActivitySummary::setTotalDistance()
     * @uses TripReportActivitySummary::setTotalConsumption()
     * @param int $executionCount
     * @param float $totalDuration
     * @param float $totalDistance
     * @param float $totalConsumption
     */
    public function __construct($executionCount = null, $totalDuration = null, $totalDistance = null, $totalConsumption = null)
    {
        $this
            ->setExecutionCount($executionCount)
            ->setTotalDuration($totalDuration)
            ->setTotalDistance($totalDistance)
            ->setTotalConsumption($totalConsumption);
    }
    /**
     * Get ExecutionCount value
     * @return int
     */
    public function getExecutionCount()
    {
        return $this->ExecutionCount;
    }
    /**
     * Set ExecutionCount value
     * @param int $executionCount
     * @return \StructType\TripReportActivitySummary
     */
    public function setExecutionCount($executionCount = null)
    {
        // validation for constraint: int
        if (!is_null($executionCount) && !(is_int($executionCount) || ctype_digit($executionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($executionCount, true), gettype($executionCount)), __LINE__);
        }
        $this->ExecutionCount = $executionCount;
        return $this;
    }
    /**
     * Get TotalDuration value
     * @return float
     */
    public function getTotalDuration()
    {
        return $this->TotalDuration;
    }
    /**
     * Set TotalDuration value
     * @param float $totalDuration
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalDuration($totalDuration = null)
    {
        // validation for constraint: float
        if (!is_null($totalDuration) && !(is_float($totalDuration) || is_numeric($totalDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDuration, true), gettype($totalDuration)), __LINE__);
        }
        $this->TotalDuration = $totalDuration;
        return $this;
    }
    /**
     * Get TotalDistance value
     * @return float
     */
    public function getTotalDistance()
    {
        return $this->TotalDistance;
    }
    /**
     * Set TotalDistance value
     * @param float $totalDistance
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalDistance($totalDistance = null)
    {
        // validation for constraint: float
        if (!is_null($totalDistance) && !(is_float($totalDistance) || is_numeric($totalDistance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDistance, true), gettype($totalDistance)), __LINE__);
        }
        $this->TotalDistance = $totalDistance;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        // validation for constraint: float
        if (!is_null($totalConsumption) && !(is_float($totalConsumption) || is_numeric($totalConsumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalConsumption, true), gettype($totalConsumption)), __LINE__);
        }
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
}
