<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripInterfaceResult_v3 StructType
 * @subpackage Structs
 */
class TripInterfaceResult_v3 extends Trip
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ModificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationNumber;
    /**
     * The CreatedByDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CreatedByDriver;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The ModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationID;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Consultations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfConsultation_V2
     */
    public $Consultations;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The PalletInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $ExtraInfos;
    /**
     * The Transfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transfer
     */
    public $Transfer;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceInterfaceResult_v2
     */
    public $Places;
    /**
     * The TachoActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The Registrations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegistration_v2
     */
    public $Registrations;
    /**
     * Constructor method for TripInterfaceResult_v3
     * @uses TripInterfaceResult_v3::setStatus()
     * @uses TripInterfaceResult_v3::setStartDate()
     * @uses TripInterfaceResult_v3::setEndDate()
     * @uses TripInterfaceResult_v3::setExternalSynchStatus()
     * @uses TripInterfaceResult_v3::setModificationDate()
     * @uses TripInterfaceResult_v3::setModificationNumber()
     * @uses TripInterfaceResult_v3::setCreatedByDriver()
     * @uses TripInterfaceResult_v3::setCancelStatus()
     * @uses TripInterfaceResult_v3::setModificationID()
     * @uses TripInterfaceResult_v3::setAuthor()
     * @uses TripInterfaceResult_v3::setConsultations()
     * @uses TripInterfaceResult_v3::setAnomalies()
     * @uses TripInterfaceResult_v3::setPalletInfos()
     * @uses TripInterfaceResult_v3::setExtraInfos()
     * @uses TripInterfaceResult_v3::setTransfer()
     * @uses TripInterfaceResult_v3::setPlaces()
     * @uses TripInterfaceResult_v3::setTachoActivities()
     * @uses TripInterfaceResult_v3::setRegistrations()
     * @param string $status
     * @param string $startDate
     * @param string $endDate
     * @param string $externalSynchStatus
     * @param string $modificationDate
     * @param int $modificationNumber
     * @param bool $createdByDriver
     * @param string $cancelStatus
     * @param int $modificationID
     * @param string $author
     * @param \ArrayType\ArrayOfConsultation_V2 $consultations
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @param \StructType\Transfer $transfer
     * @param \ArrayType\ArrayOfPlaceInterfaceResult_v2 $places
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     */
    public function __construct($status = null, $startDate = null, $endDate = null, $externalSynchStatus = null, $modificationDate = null, $modificationNumber = null, $createdByDriver = null, $cancelStatus = null, $modificationID = null, $author = null, \ArrayType\ArrayOfConsultation_V2 $consultations = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfExtraInfo $palletInfos = null, \ArrayType\ArrayOfExtraInfo $extraInfos = null, \StructType\Transfer $transfer = null, \ArrayType\ArrayOfPlaceInterfaceResult_v2 $places = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, \ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this
            ->setStatus($status)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setModificationDate($modificationDate)
            ->setModificationNumber($modificationNumber)
            ->setCreatedByDriver($createdByDriver)
            ->setCancelStatus($cancelStatus)
            ->setModificationID($modificationID)
            ->setAuthor($author)
            ->setConsultations($consultations)
            ->setAnomalies($anomalies)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setTransfer($transfer)
            ->setPlaces($places)
            ->setTachoActivities($tachoActivities)
            ->setRegistrations($registrations);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ModificationNumber value
     * @return int
     */
    public function getModificationNumber()
    {
        return $this->ModificationNumber;
    }
    /**
     * Set ModificationNumber value
     * @param int $modificationNumber
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setModificationNumber($modificationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($modificationNumber) && !(is_int($modificationNumber) || ctype_digit($modificationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationNumber, true), gettype($modificationNumber)), __LINE__);
        }
        $this->ModificationNumber = $modificationNumber;
        return $this;
    }
    /**
     * Get CreatedByDriver value
     * @return bool
     */
    public function getCreatedByDriver()
    {
        return $this->CreatedByDriver;
    }
    /**
     * Set CreatedByDriver value
     * @param bool $createdByDriver
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setCreatedByDriver($createdByDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdByDriver) && !is_bool($createdByDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdByDriver, true), gettype($createdByDriver)), __LINE__);
        }
        $this->CreatedByDriver = $createdByDriver;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get ModificationID value
     * @return int
     */
    public function getModificationID()
    {
        return $this->ModificationID;
    }
    /**
     * Set ModificationID value
     * @param int $modificationID
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setModificationID($modificationID = null)
    {
        // validation for constraint: int
        if (!is_null($modificationID) && !(is_int($modificationID) || ctype_digit($modificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationID, true), gettype($modificationID)), __LINE__);
        }
        $this->ModificationID = $modificationID;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Consultations value
     * @return \ArrayType\ArrayOfConsultation_V2|null
     */
    public function getConsultations()
    {
        return $this->Consultations;
    }
    /**
     * Set Consultations value
     * @param \ArrayType\ArrayOfConsultation_V2 $consultations
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setConsultations(\ArrayType\ArrayOfConsultation_V2 $consultations = null)
    {
        $this->Consultations = $consultations;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get Transfer value
     * @return \StructType\Transfer|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @param \StructType\Transfer $transfer
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setTransfer(\StructType\Transfer $transfer = null)
    {
        $this->Transfer = $transfer;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceInterfaceResult_v2|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceInterfaceResult_v2 $places
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceInterfaceResult_v2 $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \ArrayType\ArrayOfRegistration_v2|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     * @return \StructType\TripInterfaceResult_v3
     */
    public function setRegistrations(\ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
}
