<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripInsert StructType
 * @subpackage Structs
 */
class TripInsert extends Trip
{
    /**
     * The SalesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceInsert
     */
    public $Places;
    /**
     * The PlanningConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for TripInsert
     * @uses TripInsert::setSalesPrice()
     * @uses TripInsert::setPlaces()
     * @uses TripInsert::setPlanningConfig()
     * @param float $salesPrice
     * @param \ArrayType\ArrayOfPlaceInsert $places
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct($salesPrice = null, \ArrayType\ArrayOfPlaceInsert $places = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setSalesPrice($salesPrice)
            ->setPlaces($places)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\TripInsert
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceInsert|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceInsert $places
     * @return \StructType\TripInsert
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceInsert $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\TripInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
}
