<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trip StructType
 * @subpackage Structs
 */
abstract class Trip extends AbstractStructBase
{
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The OrderSeq
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSeq;
    /**
     * The CustomNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomNr;
    /**
     * The TypeCustom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TypeCustom;
    /**
     * The Overwrite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Overwrite;
    /**
     * The TripId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripId;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The References
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $References;
    /**
     * The StartTripAct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $StartTripAct;
    /**
     * The StopTripAct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $StopTripAct;
    /**
     * Constructor method for Trip
     * @uses Trip::setExecutionDate()
     * @uses Trip::setOrderSeq()
     * @uses Trip::setCustomNr()
     * @uses Trip::setTypeCustom()
     * @uses Trip::setOverwrite()
     * @uses Trip::setTripId()
     * @uses Trip::setDriverDisplay()
     * @uses Trip::setComment()
     * @uses Trip::setReferences()
     * @uses Trip::setStartTripAct()
     * @uses Trip::setStopTripAct()
     * @param string $executionDate
     * @param int $orderSeq
     * @param int $customNr
     * @param int $typeCustom
     * @param bool $overwrite
     * @param string $tripId
     * @param string $driverDisplay
     * @param string $comment
     * @param \StructType\Reference $references
     * @param \StructType\Activity $startTripAct
     * @param \StructType\Activity $stopTripAct
     */
    public function __construct($executionDate = null, $orderSeq = null, $customNr = null, $typeCustom = null, $overwrite = null, $tripId = null, $driverDisplay = null, $comment = null, \StructType\Reference $references = null, \StructType\Activity $startTripAct = null, \StructType\Activity $stopTripAct = null)
    {
        $this
            ->setExecutionDate($executionDate)
            ->setOrderSeq($orderSeq)
            ->setCustomNr($customNr)
            ->setTypeCustom($typeCustom)
            ->setOverwrite($overwrite)
            ->setTripId($tripId)
            ->setDriverDisplay($driverDisplay)
            ->setComment($comment)
            ->setReferences($references)
            ->setStartTripAct($startTripAct)
            ->setStopTripAct($stopTripAct);
    }
    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }
    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return \StructType\Trip
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        $this->ExecutionDate = $executionDate;
        return $this;
    }
    /**
     * Get OrderSeq value
     * @return int
     */
    public function getOrderSeq()
    {
        return $this->OrderSeq;
    }
    /**
     * Set OrderSeq value
     * @param int $orderSeq
     * @return \StructType\Trip
     */
    public function setOrderSeq($orderSeq = null)
    {
        // validation for constraint: int
        if (!is_null($orderSeq) && !(is_int($orderSeq) || ctype_digit($orderSeq))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSeq, true), gettype($orderSeq)), __LINE__);
        }
        $this->OrderSeq = $orderSeq;
        return $this;
    }
    /**
     * Get CustomNr value
     * @return int
     */
    public function getCustomNr()
    {
        return $this->CustomNr;
    }
    /**
     * Set CustomNr value
     * @param int $customNr
     * @return \StructType\Trip
     */
    public function setCustomNr($customNr = null)
    {
        // validation for constraint: int
        if (!is_null($customNr) && !(is_int($customNr) || ctype_digit($customNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customNr, true), gettype($customNr)), __LINE__);
        }
        $this->CustomNr = $customNr;
        return $this;
    }
    /**
     * Get TypeCustom value
     * @return int
     */
    public function getTypeCustom()
    {
        return $this->TypeCustom;
    }
    /**
     * Set TypeCustom value
     * @param int $typeCustom
     * @return \StructType\Trip
     */
    public function setTypeCustom($typeCustom = null)
    {
        // validation for constraint: int
        if (!is_null($typeCustom) && !(is_int($typeCustom) || ctype_digit($typeCustom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeCustom, true), gettype($typeCustom)), __LINE__);
        }
        $this->TypeCustom = $typeCustom;
        return $this;
    }
    /**
     * Get Overwrite value
     * @return bool
     */
    public function getOverwrite()
    {
        return $this->Overwrite;
    }
    /**
     * Set Overwrite value
     * @param bool $overwrite
     * @return \StructType\Trip
     */
    public function setOverwrite($overwrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($overwrite) && !is_bool($overwrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overwrite, true), gettype($overwrite)), __LINE__);
        }
        $this->Overwrite = $overwrite;
        return $this;
    }
    /**
     * Get TripId value
     * @return string|null
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param string $tripId
     * @return \StructType\Trip
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: string
        if (!is_null($tripId) && !is_string($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripId, true), gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Trip
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Trip
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get References value
     * @return \StructType\Reference|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \StructType\Reference $references
     * @return \StructType\Trip
     */
    public function setReferences(\StructType\Reference $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get StartTripAct value
     * @return \StructType\Activity|null
     */
    public function getStartTripAct()
    {
        return $this->StartTripAct;
    }
    /**
     * Set StartTripAct value
     * @param \StructType\Activity $startTripAct
     * @return \StructType\Trip
     */
    public function setStartTripAct(\StructType\Activity $startTripAct = null)
    {
        $this->StartTripAct = $startTripAct;
        return $this;
    }
    /**
     * Get StopTripAct value
     * @return \StructType\Activity|null
     */
    public function getStopTripAct()
    {
        return $this->StopTripAct;
    }
    /**
     * Set StopTripAct value
     * @param \StructType\Activity $stopTripAct
     * @return \StructType\Trip
     */
    public function setStopTripAct(\StructType\Activity $stopTripAct = null)
    {
        $this->StopTripAct = $stopTripAct;
        return $this;
    }
}
