<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer StructType
 * @subpackage Structs
 */
class Transfer extends AbstractStructBase
{
    /**
     * The TransferStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The TransferDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferDateTime;
    /**
     * The TransferCancelID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TransferCancelID;
    /**
     * The TransferID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TransferID;
    /**
     * The SendDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SendDateTime;
    /**
     * Constructor method for Transfer
     * @uses Transfer::setTransferStatus()
     * @uses Transfer::setTransferDateTime()
     * @uses Transfer::setTransferCancelID()
     * @uses Transfer::setTransferID()
     * @uses Transfer::setSendDateTime()
     * @param string $transferStatus
     * @param string $transferDateTime
     * @param int $transferCancelID
     * @param int $transferID
     * @param string $sendDateTime
     */
    public function __construct($transferStatus = null, $transferDateTime = null, $transferCancelID = null, $transferID = null, $sendDateTime = null)
    {
        $this
            ->setTransferStatus($transferStatus)
            ->setTransferDateTime($transferDateTime)
            ->setTransferCancelID($transferCancelID)
            ->setTransferID($transferID)
            ->setSendDateTime($sendDateTime);
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\Transfer
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($transferStatus) ? implode(', ', $transferStatus) : var_export($transferStatus, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get TransferDateTime value
     * @return string
     */
    public function getTransferDateTime()
    {
        return $this->TransferDateTime;
    }
    /**
     * Set TransferDateTime value
     * @param string $transferDateTime
     * @return \StructType\Transfer
     */
    public function setTransferDateTime($transferDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($transferDateTime) && !is_string($transferDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDateTime, true), gettype($transferDateTime)), __LINE__);
        }
        $this->TransferDateTime = $transferDateTime;
        return $this;
    }
    /**
     * Get TransferCancelID value
     * @return int
     */
    public function getTransferCancelID()
    {
        return $this->TransferCancelID;
    }
    /**
     * Set TransferCancelID value
     * @param int $transferCancelID
     * @return \StructType\Transfer
     */
    public function setTransferCancelID($transferCancelID = null)
    {
        // validation for constraint: int
        if (!is_null($transferCancelID) && !(is_int($transferCancelID) || ctype_digit($transferCancelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transferCancelID, true), gettype($transferCancelID)), __LINE__);
        }
        $this->TransferCancelID = $transferCancelID;
        return $this;
    }
    /**
     * Get TransferID value
     * @return int
     */
    public function getTransferID()
    {
        return $this->TransferID;
    }
    /**
     * Set TransferID value
     * @param int $transferID
     * @return \StructType\Transfer
     */
    public function setTransferID($transferID = null)
    {
        // validation for constraint: int
        if (!is_null($transferID) && !(is_int($transferID) || ctype_digit($transferID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transferID, true), gettype($transferID)), __LINE__);
        }
        $this->TransferID = $transferID;
        return $this;
    }
    /**
     * Get SendDateTime value
     * @return string
     */
    public function getSendDateTime()
    {
        return $this->SendDateTime;
    }
    /**
     * Set SendDateTime value
     * @param string $sendDateTime
     * @return \StructType\Transfer
     */
    public function setSendDateTime($sendDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sendDateTime) && !is_string($sendDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendDateTime, true), gettype($sendDateTime)), __LINE__);
        }
        $this->SendDateTime = $sendDateTime;
        return $this;
    }
}
