<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerGroupItem StructType
 * @subpackage Structs
 */
class TrailerGroupItem extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The TrailerSubGroupList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrailerSubGroupItem
     */
    public $TrailerSubGroupList;
    /**
     * Constructor method for TrailerGroupItem
     * @uses TrailerGroupItem::setGroupCode()
     * @uses TrailerGroupItem::setGroupName()
     * @uses TrailerGroupItem::setTrailerSubGroupList()
     * @param string $groupCode
     * @param string $groupName
     * @param \ArrayType\ArrayOfTrailerSubGroupItem $trailerSubGroupList
     */
    public function __construct($groupCode = null, $groupName = null, \ArrayType\ArrayOfTrailerSubGroupItem $trailerSubGroupList = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setTrailerSubGroupList($trailerSubGroupList);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\TrailerGroupItem
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\TrailerGroupItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get TrailerSubGroupList value
     * @return \ArrayType\ArrayOfTrailerSubGroupItem|null
     */
    public function getTrailerSubGroupList()
    {
        return $this->TrailerSubGroupList;
    }
    /**
     * Set TrailerSubGroupList value
     * @param \ArrayType\ArrayOfTrailerSubGroupItem $trailerSubGroupList
     * @return \StructType\TrailerGroupItem
     */
    public function setTrailerSubGroupList(\ArrayType\ArrayOfTrailerSubGroupItem $trailerSubGroupList = null)
    {
        $this->TrailerSubGroupList = $trailerSubGroupList;
        return $this;
    }
}
