<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageSend StructType
 * @subpackage Structs
 */
class TextMessageSend extends TextMessage
{
    /**
     * The VehicleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VehicleType;
    /**
     * The Reply_TextMessageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Reply_TextMessageID;
    /**
     * The ForceOBCWakeUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ForceOBCWakeUp;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The AdditionalRecipients
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAdditionalRecipient
     */
    public $AdditionalRecipients;
    /**
     * Constructor method for TextMessageSend
     * @uses TextMessageSend::setVehicleType()
     * @uses TextMessageSend::setReply_TextMessageID()
     * @uses TextMessageSend::setForceOBCWakeUp()
     * @uses TextMessageSend::setVehicles()
     * @uses TextMessageSend::setAdditionalRecipients()
     * @param string $vehicleType
     * @param int $reply_TextMessageID
     * @param bool $forceOBCWakeUp
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfAdditionalRecipient $additionalRecipients
     */
    public function __construct($vehicleType = null, $reply_TextMessageID = null, $forceOBCWakeUp = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfAdditionalRecipient $additionalRecipients = null)
    {
        $this
            ->setVehicleType($vehicleType)
            ->setReply_TextMessageID($reply_TextMessageID)
            ->setForceOBCWakeUp($forceOBCWakeUp)
            ->setVehicles($vehicles)
            ->setAdditionalRecipients($additionalRecipients);
    }
    /**
     * Get VehicleType value
     * @return string
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @uses \EnumType\EnumVehicleType::valueIsValid()
     * @uses \EnumType\EnumVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleType
     * @return \StructType\TextMessageSend
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumVehicleType::valueIsValid($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumVehicleType', is_array($vehicleType) ? implode(', ', $vehicleType) : var_export($vehicleType, true), implode(', ', \EnumType\EnumVehicleType::getValidValues())), __LINE__);
        }
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get Reply_TextMessageID value
     * @return int
     */
    public function getReply_TextMessageID()
    {
        return $this->Reply_TextMessageID;
    }
    /**
     * Set Reply_TextMessageID value
     * @param int $reply_TextMessageID
     * @return \StructType\TextMessageSend
     */
    public function setReply_TextMessageID($reply_TextMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($reply_TextMessageID) && !(is_int($reply_TextMessageID) || ctype_digit($reply_TextMessageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reply_TextMessageID, true), gettype($reply_TextMessageID)), __LINE__);
        }
        $this->Reply_TextMessageID = $reply_TextMessageID;
        return $this;
    }
    /**
     * Get ForceOBCWakeUp value
     * @return bool
     */
    public function getForceOBCWakeUp()
    {
        return $this->ForceOBCWakeUp;
    }
    /**
     * Set ForceOBCWakeUp value
     * @param bool $forceOBCWakeUp
     * @return \StructType\TextMessageSend
     */
    public function setForceOBCWakeUp($forceOBCWakeUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceOBCWakeUp) && !is_bool($forceOBCWakeUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceOBCWakeUp, true), gettype($forceOBCWakeUp)), __LINE__);
        }
        $this->ForceOBCWakeUp = $forceOBCWakeUp;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\TextMessageSend
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get AdditionalRecipients value
     * @return \ArrayType\ArrayOfAdditionalRecipient|null
     */
    public function getAdditionalRecipients()
    {
        return $this->AdditionalRecipients;
    }
    /**
     * Set AdditionalRecipients value
     * @param \ArrayType\ArrayOfAdditionalRecipient $additionalRecipients
     * @return \StructType\TextMessageSend
     */
    public function setAdditionalRecipients(\ArrayType\ArrayOfAdditionalRecipient $additionalRecipients = null)
    {
        $this->AdditionalRecipients = $additionalRecipients;
        return $this;
    }
}
