<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessage StructType
 * @subpackage Structs
 */
class TextMessage extends AbstractStructBase
{
    /**
     * The ReadConfirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReadConfirmation;
    /**
     * The ReadDeadlineDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDeadlineDate;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for TextMessage
     * @uses TextMessage::setReadConfirmation()
     * @uses TextMessage::setReadDeadlineDate()
     * @uses TextMessage::setMessage()
     * @param bool $readConfirmation
     * @param string $readDeadlineDate
     * @param string $message
     */
    public function __construct($readConfirmation = null, $readDeadlineDate = null, $message = null)
    {
        $this
            ->setReadConfirmation($readConfirmation)
            ->setReadDeadlineDate($readDeadlineDate)
            ->setMessage($message);
    }
    /**
     * Get ReadConfirmation value
     * @return bool
     */
    public function getReadConfirmation()
    {
        return $this->ReadConfirmation;
    }
    /**
     * Set ReadConfirmation value
     * @param bool $readConfirmation
     * @return \StructType\TextMessage
     */
    public function setReadConfirmation($readConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($readConfirmation) && !is_bool($readConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($readConfirmation, true), gettype($readConfirmation)), __LINE__);
        }
        $this->ReadConfirmation = $readConfirmation;
        return $this;
    }
    /**
     * Get ReadDeadlineDate value
     * @return string
     */
    public function getReadDeadlineDate()
    {
        return $this->ReadDeadlineDate;
    }
    /**
     * Set ReadDeadlineDate value
     * @param string $readDeadlineDate
     * @return \StructType\TextMessage
     */
    public function setReadDeadlineDate($readDeadlineDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDeadlineDate) && !is_string($readDeadlineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readDeadlineDate, true), gettype($readDeadlineDate)), __LINE__);
        }
        $this->ReadDeadlineDate = $readDeadlineDate;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TextMessage
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
