<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureSetting StructType
 * @subpackage Structs
 */
class TemperatureSetting extends AbstractStructBase
{
    /**
     * The MinValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MinValue;
    /**
     * The MaxValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxValue;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zone;
    /**
     * Constructor method for TemperatureSetting
     * @uses TemperatureSetting::setMinValue()
     * @uses TemperatureSetting::setMaxValue()
     * @uses TemperatureSetting::setZone()
     * @param float $minValue
     * @param float $maxValue
     * @param string $zone
     */
    public function __construct($minValue = null, $maxValue = null, $zone = null)
    {
        $this
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setZone($zone);
    }
    /**
     * Get MinValue value
     * @return float
     */
    public function getMinValue()
    {
        return $this->MinValue;
    }
    /**
     * Set MinValue value
     * @param float $minValue
     * @return \StructType\TemperatureSetting
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: float
        if (!is_null($minValue) && !(is_float($minValue) || is_numeric($minValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minValue, true), gettype($minValue)), __LINE__);
        }
        $this->MinValue = $minValue;
        return $this;
    }
    /**
     * Get MaxValue value
     * @return float
     */
    public function getMaxValue()
    {
        return $this->MaxValue;
    }
    /**
     * Set MaxValue value
     * @param float $maxValue
     * @return \StructType\TemperatureSetting
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: float
        if (!is_null($maxValue) && !(is_float($maxValue) || is_numeric($maxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxValue, true), gettype($maxValue)), __LINE__);
        }
        $this->MaxValue = $maxValue;
        return $this;
    }
    /**
     * Get Zone value
     * @return string
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @uses \EnumType\EnumTemperatureZone::valueIsValid()
     * @uses \EnumType\EnumTemperatureZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zone
     * @return \StructType\TemperatureSetting
     */
    public function setZone($zone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTemperatureZone::valueIsValid($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTemperatureZone', is_array($zone) ? implode(', ', $zone) : var_export($zone, true), implode(', ', \EnumType\EnumTemperatureZone::getValidValues())), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
}
