<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureMeasurement StructType
 * @subpackage Structs
 */
class TemperatureMeasurement extends AbstractStructBase
{
    /**
     * The TemperatureDeviceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TemperatureDeviceID;
    /**
     * The MeasurementDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MeasurementDate;
    /**
     * The KmsVehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsVehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The MeasurementsData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeasurementsData;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The EngineActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEngineActivity
     */
    public $EngineActivity;
    /**
     * The Temperatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTemperatureInformation
     */
    public $Temperatures;
    /**
     * Constructor method for TemperatureMeasurement
     * @uses TemperatureMeasurement::setTemperatureDeviceID()
     * @uses TemperatureMeasurement::setMeasurementDate()
     * @uses TemperatureMeasurement::setKmsVehicle()
     * @uses TemperatureMeasurement::setDriver()
     * @uses TemperatureMeasurement::setTrailer()
     * @uses TemperatureMeasurement::setVehicle()
     * @uses TemperatureMeasurement::setMeasurementsData()
     * @uses TemperatureMeasurement::setPosition()
     * @uses TemperatureMeasurement::setEngineActivity()
     * @uses TemperatureMeasurement::setTemperatures()
     * @param int $temperatureDeviceID
     * @param string $measurementDate
     * @param int $kmsVehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $measurementsData
     * @param \StructType\Position $position
     * @param \ArrayType\ArrayOfEngineActivity $engineActivity
     * @param \ArrayType\ArrayOfTemperatureInformation $temperatures
     */
    public function __construct($temperatureDeviceID = null, $measurementDate = null, $kmsVehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierVehicleResult $vehicle = null, $measurementsData = null, \StructType\Position $position = null, \ArrayType\ArrayOfEngineActivity $engineActivity = null, \ArrayType\ArrayOfTemperatureInformation $temperatures = null)
    {
        $this
            ->setTemperatureDeviceID($temperatureDeviceID)
            ->setMeasurementDate($measurementDate)
            ->setKmsVehicle($kmsVehicle)
            ->setDriver($driver)
            ->setTrailer($trailer)
            ->setVehicle($vehicle)
            ->setMeasurementsData($measurementsData)
            ->setPosition($position)
            ->setEngineActivity($engineActivity)
            ->setTemperatures($temperatures);
    }
    /**
     * Get TemperatureDeviceID value
     * @return int
     */
    public function getTemperatureDeviceID()
    {
        return $this->TemperatureDeviceID;
    }
    /**
     * Set TemperatureDeviceID value
     * @param int $temperatureDeviceID
     * @return \StructType\TemperatureMeasurement
     */
    public function setTemperatureDeviceID($temperatureDeviceID = null)
    {
        // validation for constraint: int
        if (!is_null($temperatureDeviceID) && !(is_int($temperatureDeviceID) || ctype_digit($temperatureDeviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temperatureDeviceID, true), gettype($temperatureDeviceID)), __LINE__);
        }
        $this->TemperatureDeviceID = $temperatureDeviceID;
        return $this;
    }
    /**
     * Get MeasurementDate value
     * @return string
     */
    public function getMeasurementDate()
    {
        return $this->MeasurementDate;
    }
    /**
     * Set MeasurementDate value
     * @param string $measurementDate
     * @return \StructType\TemperatureMeasurement
     */
    public function setMeasurementDate($measurementDate = null)
    {
        // validation for constraint: string
        if (!is_null($measurementDate) && !is_string($measurementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementDate, true), gettype($measurementDate)), __LINE__);
        }
        $this->MeasurementDate = $measurementDate;
        return $this;
    }
    /**
     * Get KmsVehicle value
     * @return int
     */
    public function getKmsVehicle()
    {
        return $this->KmsVehicle;
    }
    /**
     * Set KmsVehicle value
     * @param int $kmsVehicle
     * @return \StructType\TemperatureMeasurement
     */
    public function setKmsVehicle($kmsVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($kmsVehicle) && !(is_int($kmsVehicle) || ctype_digit($kmsVehicle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsVehicle, true), gettype($kmsVehicle)), __LINE__);
        }
        $this->KmsVehicle = $kmsVehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TemperatureMeasurement
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TemperatureMeasurement
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TemperatureMeasurement
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get MeasurementsData value
     * @return string|null
     */
    public function getMeasurementsData()
    {
        return $this->MeasurementsData;
    }
    /**
     * Set MeasurementsData value
     * @param string $measurementsData
     * @return \StructType\TemperatureMeasurement
     */
    public function setMeasurementsData($measurementsData = null)
    {
        // validation for constraint: string
        if (!is_null($measurementsData) && !is_string($measurementsData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementsData, true), gettype($measurementsData)), __LINE__);
        }
        $this->MeasurementsData = $measurementsData;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\TemperatureMeasurement
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get EngineActivity value
     * @return \ArrayType\ArrayOfEngineActivity|null
     */
    public function getEngineActivity()
    {
        return $this->EngineActivity;
    }
    /**
     * Set EngineActivity value
     * @param \ArrayType\ArrayOfEngineActivity $engineActivity
     * @return \StructType\TemperatureMeasurement
     */
    public function setEngineActivity(\ArrayType\ArrayOfEngineActivity $engineActivity = null)
    {
        $this->EngineActivity = $engineActivity;
        return $this;
    }
    /**
     * Get Temperatures value
     * @return \ArrayType\ArrayOfTemperatureInformation|null
     */
    public function getTemperatures()
    {
        return $this->Temperatures;
    }
    /**
     * Set Temperatures value
     * @param \ArrayType\ArrayOfTemperatureInformation $temperatures
     * @return \StructType\TemperatureMeasurement
     */
    public function setTemperatures(\ArrayType\ArrayOfTemperatureInformation $temperatures = null)
    {
        $this->Temperatures = $temperatures;
        return $this;
    }
}
