<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureInformation StructType
 * @subpackage Structs
 */
class TemperatureInformation extends AbstractStructBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Zone;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaximumTemperature;
    /**
     * The CurrentTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CurrentTemperature;
    /**
     * The TemperatureType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TemperatureType;
    /**
     * Constructor method for TemperatureInformation
     * @uses TemperatureInformation::setZone()
     * @uses TemperatureInformation::setMinimumTemperature()
     * @uses TemperatureInformation::setMaximumTemperature()
     * @uses TemperatureInformation::setCurrentTemperature()
     * @uses TemperatureInformation::setTemperatureType()
     * @param int $zone
     * @param float $minimumTemperature
     * @param float $maximumTemperature
     * @param float $currentTemperature
     * @param string $temperatureType
     */
    public function __construct($zone = null, $minimumTemperature = null, $maximumTemperature = null, $currentTemperature = null, $temperatureType = null)
    {
        $this
            ->setZone($zone)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setCurrentTemperature($currentTemperature)
            ->setTemperatureType($temperatureType);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\TemperatureInformation
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return float
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param float $minimumTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setMinimumTemperature($minimumTemperature = null)
    {
        // validation for constraint: float
        if (!is_null($minimumTemperature) && !(is_float($minimumTemperature) || is_numeric($minimumTemperature))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumTemperature, true), gettype($minimumTemperature)), __LINE__);
        }
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return float
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param float $maximumTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setMaximumTemperature($maximumTemperature = null)
    {
        // validation for constraint: float
        if (!is_null($maximumTemperature) && !(is_float($maximumTemperature) || is_numeric($maximumTemperature))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumTemperature, true), gettype($maximumTemperature)), __LINE__);
        }
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get CurrentTemperature value
     * @return float
     */
    public function getCurrentTemperature()
    {
        return $this->CurrentTemperature;
    }
    /**
     * Set CurrentTemperature value
     * @param float $currentTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setCurrentTemperature($currentTemperature = null)
    {
        // validation for constraint: float
        if (!is_null($currentTemperature) && !(is_float($currentTemperature) || is_numeric($currentTemperature))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentTemperature, true), gettype($currentTemperature)), __LINE__);
        }
        $this->CurrentTemperature = $currentTemperature;
        return $this;
    }
    /**
     * Get TemperatureType value
     * @return string
     */
    public function getTemperatureType()
    {
        return $this->TemperatureType;
    }
    /**
     * Set TemperatureType value
     * @uses \EnumType\EnumTemperatureType::valueIsValid()
     * @uses \EnumType\EnumTemperatureType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $temperatureType
     * @return \StructType\TemperatureInformation
     */
    public function setTemperatureType($temperatureType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTemperatureType::valueIsValid($temperatureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTemperatureType', is_array($temperatureType) ? implode(', ', $temperatureType) : var_export($temperatureType, true), implode(', ', \EnumType\EnumTemperatureType::getValidValues())), __LINE__);
        }
        $this->TemperatureType = $temperatureType;
        return $this;
    }
}
