<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureInfoItem StructType
 * @subpackage Structs
 */
class TemperatureInfoItem extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The DateLastUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateLastUpdate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for TemperatureInfoItem
     * @uses TemperatureInfoItem::setValue()
     * @uses TemperatureInfoItem::setDateLastUpdate()
     * @uses TemperatureInfoItem::setName()
     * @param float $value
     * @param string $dateLastUpdate
     * @param string $name
     */
    public function __construct($value = null, $dateLastUpdate = null, $name = null)
    {
        $this
            ->setValue($value)
            ->setDateLastUpdate($dateLastUpdate)
            ->setName($name);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\TemperatureInfoItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get DateLastUpdate value
     * @return string
     */
    public function getDateLastUpdate()
    {
        return $this->DateLastUpdate;
    }
    /**
     * Set DateLastUpdate value
     * @param string $dateLastUpdate
     * @return \StructType\TemperatureInfoItem
     */
    public function setDateLastUpdate($dateLastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUpdate) && !is_string($dateLastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLastUpdate, true), gettype($dateLastUpdate)), __LINE__);
        }
        $this->DateLastUpdate = $dateLastUpdate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TemperatureInfoItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
