<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelemetricDataSelection StructType
 * @subpackage Structs
 */
class TelemetricDataSelection extends AbstractStructBase
{
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeriodSelectionWithDateType
     */
    public $DateTimeRangeSelection;
    /**
     * The DateTimeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeAndIdSelection
     */
    public $DateTimeSelection;
    /**
     * The AdditionalParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalParameters;
    /**
     * Constructor method for TelemetricDataSelection
     * @uses TelemetricDataSelection::setDrivers()
     * @uses TelemetricDataSelection::setVehicles()
     * @uses TelemetricDataSelection::setTrailers()
     * @uses TelemetricDataSelection::setDateTimeRangeSelection()
     * @uses TelemetricDataSelection::setDateTimeSelection()
     * @uses TelemetricDataSelection::setAdditionalParameters()
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @param \StructType\DateTimeAndIdSelection $dateTimeSelection
     * @param \ArrayType\ArrayOfString $additionalParameters
     */
    public function __construct(\ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null, \StructType\DateTimeAndIdSelection $dateTimeSelection = null, \ArrayType\ArrayOfString $additionalParameters = null)
    {
        $this
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDateTimeSelection($dateTimeSelection)
            ->setAdditionalParameters($additionalParameters);
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\TelemetricDataSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\TelemetricDataSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\TelemetricDataSelection
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\PeriodSelectionWithDateType|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @return \StructType\TelemetricDataSelection
     */
    public function setDateTimeRangeSelection(\StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get DateTimeSelection value
     * @return \StructType\DateTimeAndIdSelection|null
     */
    public function getDateTimeSelection()
    {
        return $this->DateTimeSelection;
    }
    /**
     * Set DateTimeSelection value
     * @param \StructType\DateTimeAndIdSelection $dateTimeSelection
     * @return \StructType\TelemetricDataSelection
     */
    public function setDateTimeSelection(\StructType\DateTimeAndIdSelection $dateTimeSelection = null)
    {
        $this->DateTimeSelection = $dateTimeSelection;
        return $this;
    }
    /**
     * Get AdditionalParameters value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalParameters()
    {
        return $this->AdditionalParameters;
    }
    /**
     * Set AdditionalParameters value
     * @param \ArrayType\ArrayOfString $additionalParameters
     * @return \StructType\TelemetricDataSelection
     */
    public function setAdditionalParameters(\ArrayType\ArrayOfString $additionalParameters = null)
    {
        $this->AdditionalParameters = $additionalParameters;
        return $this;
    }
}
