<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SummarizedTachoDataSelection StructType
 * @subpackage Structs
 */
class SummarizedTachoDataSelection extends AbstractStructBase
{
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The SummaryLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummaryLevel;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for SummarizedTachoDataSelection
     * @uses SummarizedTachoDataSelection::setDataSource()
     * @uses SummarizedTachoDataSelection::setSummaryLevel()
     * @uses SummarizedTachoDataSelection::setDriver()
     * @uses SummarizedTachoDataSelection::setDateTimeRangeSelection()
     * @param string $dataSource
     * @param string $summaryLevel
     * @param \StructType\Identifier $driver
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($dataSource = null, $summaryLevel = null, \StructType\Identifier $driver = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setDataSource($dataSource)
            ->setSummaryLevel($summaryLevel)
            ->setDriver($driver)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\EnumTachoDataSource::valueIsValid()
     * @uses \EnumType\EnumTachoDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTachoDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTachoDataSource', is_array($dataSource) ? implode(', ', $dataSource) : var_export($dataSource, true), implode(', ', \EnumType\EnumTachoDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get SummaryLevel value
     * @return string
     */
    public function getSummaryLevel()
    {
        return $this->SummaryLevel;
    }
    /**
     * Set SummaryLevel value
     * @uses \EnumType\EnumSummaryLevel::valueIsValid()
     * @uses \EnumType\EnumSummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summaryLevel
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setSummaryLevel($summaryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSummaryLevel::valueIsValid($summaryLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSummaryLevel', is_array($summaryLevel) ? implode(', ', $summaryLevel) : var_export($summaryLevel, true), implode(', ', \EnumType\EnumSummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummaryLevel = $summaryLevel;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
}
