<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SummarizedTachoDataItem StructType
 * @subpackage Structs
 */
class SummarizedTachoDataItem extends AbstractStructBase
{
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The KmBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmBegin;
    /**
     * The KmEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmEnd;
    /**
     * The ServiceTimesTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceTimesTotal;
    /**
     * The Ratio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Ratio;
    /**
     * The TachoDataSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoDataSummary
     */
    public $TachoDataSummary;
    /**
     * Constructor method for SummarizedTachoDataItem
     * @uses SummarizedTachoDataItem::setBeginDate()
     * @uses SummarizedTachoDataItem::setEndDate()
     * @uses SummarizedTachoDataItem::setDuration()
     * @uses SummarizedTachoDataItem::setKmBegin()
     * @uses SummarizedTachoDataItem::setKmEnd()
     * @uses SummarizedTachoDataItem::setServiceTimesTotal()
     * @uses SummarizedTachoDataItem::setRatio()
     * @uses SummarizedTachoDataItem::setTachoDataSummary()
     * @param string $beginDate
     * @param string $endDate
     * @param int $duration
     * @param int $kmBegin
     * @param int $kmEnd
     * @param int $serviceTimesTotal
     * @param float $ratio
     * @param \ArrayType\ArrayOfTachoDataSummary $tachoDataSummary
     */
    public function __construct($beginDate = null, $endDate = null, $duration = null, $kmBegin = null, $kmEnd = null, $serviceTimesTotal = null, $ratio = null, \ArrayType\ArrayOfTachoDataSummary $tachoDataSummary = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setDuration($duration)
            ->setKmBegin($kmBegin)
            ->setKmEnd($kmEnd)
            ->setServiceTimesTotal($serviceTimesTotal)
            ->setRatio($ratio)
            ->setTachoDataSummary($tachoDataSummary);
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get KmBegin value
     * @return int
     */
    public function getKmBegin()
    {
        return $this->KmBegin;
    }
    /**
     * Set KmBegin value
     * @param int $kmBegin
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setKmBegin($kmBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmBegin) && !(is_int($kmBegin) || ctype_digit($kmBegin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmBegin, true), gettype($kmBegin)), __LINE__);
        }
        $this->KmBegin = $kmBegin;
        return $this;
    }
    /**
     * Get KmEnd value
     * @return int
     */
    public function getKmEnd()
    {
        return $this->KmEnd;
    }
    /**
     * Set KmEnd value
     * @param int $kmEnd
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setKmEnd($kmEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmEnd) && !(is_int($kmEnd) || ctype_digit($kmEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmEnd, true), gettype($kmEnd)), __LINE__);
        }
        $this->KmEnd = $kmEnd;
        return $this;
    }
    /**
     * Get ServiceTimesTotal value
     * @return int
     */
    public function getServiceTimesTotal()
    {
        return $this->ServiceTimesTotal;
    }
    /**
     * Set ServiceTimesTotal value
     * @param int $serviceTimesTotal
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setServiceTimesTotal($serviceTimesTotal = null)
    {
        // validation for constraint: int
        if (!is_null($serviceTimesTotal) && !(is_int($serviceTimesTotal) || ctype_digit($serviceTimesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceTimesTotal, true), gettype($serviceTimesTotal)), __LINE__);
        }
        $this->ServiceTimesTotal = $serviceTimesTotal;
        return $this;
    }
    /**
     * Get Ratio value
     * @return float
     */
    public function getRatio()
    {
        return $this->Ratio;
    }
    /**
     * Set Ratio value
     * @param float $ratio
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setRatio($ratio = null)
    {
        // validation for constraint: float
        if (!is_null($ratio) && !(is_float($ratio) || is_numeric($ratio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ratio, true), gettype($ratio)), __LINE__);
        }
        $this->Ratio = $ratio;
        return $this;
    }
    /**
     * Get TachoDataSummary value
     * @return \ArrayType\ArrayOfTachoDataSummary|null
     */
    public function getTachoDataSummary()
    {
        return $this->TachoDataSummary;
    }
    /**
     * Set TachoDataSummary value
     * @param \ArrayType\ArrayOfTachoDataSummary $tachoDataSummary
     * @return \StructType\SummarizedTachoDataItem
     */
    public function setTachoDataSummary(\ArrayType\ArrayOfTachoDataSummary $tachoDataSummary = null)
    {
        $this->TachoDataSummary = $tachoDataSummary;
        return $this;
    }
}
