<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubChildItem StructType
 * @subpackage Structs
 */
class SubChildItem extends GroupBase
{
    /**
     * The ParentCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentCode;
    /**
     * Constructor method for SubChildItem
     * @uses SubChildItem::setParentCode()
     * @param int $parentCode
     */
    public function __construct($parentCode = null)
    {
        $this
            ->setParentCode($parentCode);
    }
    /**
     * Get ParentCode value
     * @return int
     */
    public function getParentCode()
    {
        return $this->ParentCode;
    }
    /**
     * Set ParentCode value
     * @param int $parentCode
     * @return \StructType\SubChildItem
     */
    public function setParentCode($parentCode = null)
    {
        // validation for constraint: int
        if (!is_null($parentCode) && !(is_int($parentCode) || ctype_digit($parentCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCode, true), gettype($parentCode)), __LINE__);
        }
        $this->ParentCode = $parentCode;
        return $this;
    }
}
