<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialSubChildItem StructType
 * @subpackage Structs
 */
class SocialSubChildItem extends GroupBase
{
    /**
     * The ParentCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentCode;
    /**
     * The SocialSubSubChildList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSubChildItem
     */
    public $SocialSubSubChildList;
    /**
     * Constructor method for SocialSubChildItem
     * @uses SocialSubChildItem::setParentCode()
     * @uses SocialSubChildItem::setSocialSubSubChildList()
     * @param int $parentCode
     * @param \ArrayType\ArrayOfSubChildItem $socialSubSubChildList
     */
    public function __construct($parentCode = null, \ArrayType\ArrayOfSubChildItem $socialSubSubChildList = null)
    {
        $this
            ->setParentCode($parentCode)
            ->setSocialSubSubChildList($socialSubSubChildList);
    }
    /**
     * Get ParentCode value
     * @return int
     */
    public function getParentCode()
    {
        return $this->ParentCode;
    }
    /**
     * Set ParentCode value
     * @param int $parentCode
     * @return \StructType\SocialSubChildItem
     */
    public function setParentCode($parentCode = null)
    {
        // validation for constraint: int
        if (!is_null($parentCode) && !(is_int($parentCode) || ctype_digit($parentCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCode, true), gettype($parentCode)), __LINE__);
        }
        $this->ParentCode = $parentCode;
        return $this;
    }
    /**
     * Get SocialSubSubChildList value
     * @return \ArrayType\ArrayOfSubChildItem|null
     */
    public function getSocialSubSubChildList()
    {
        return $this->SocialSubSubChildList;
    }
    /**
     * Set SocialSubSubChildList value
     * @param \ArrayType\ArrayOfSubChildItem $socialSubSubChildList
     * @return \StructType\SocialSubChildItem
     */
    public function setSocialSubSubChildList(\ArrayType\ArrayOfSubChildItem $socialSubSubChildList = null)
    {
        $this->SocialSubSubChildList = $socialSubSubChildList;
        return $this;
    }
}
