<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialProfileSelection StructType
 * @subpackage Structs
 */
class SocialProfileSelection extends AbstractStructBase
{
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * Constructor method for SocialProfileSelection
     * @uses SocialProfileSelection::setProfileType()
     * @param string $profileType
     */
    public function __construct($profileType = null)
    {
        $this
            ->setProfileType($profileType);
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumProfileType::valueIsValid()
     * @uses \EnumType\EnumProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\SocialProfileSelection
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumProfileType::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumProfileType', is_array($profileType) ? implode(', ', $profileType) : var_export($profileType, true), implode(', ', \EnumType\EnumProfileType::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
}
