<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialGroup StructType
 * @subpackage Structs
 */
class SocialGroup extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SocialSubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SocialSubGroup
     */
    public $SocialSubGroup;
    /**
     * Constructor method for SocialGroup
     * @uses SocialGroup::setStartDate()
     * @uses SocialGroup::setEndDate()
     * @uses SocialGroup::setName()
     * @uses SocialGroup::setSocialSubGroup()
     * @param string $startDate
     * @param string $endDate
     * @param string $name
     * @param \StructType\SocialSubGroup $socialSubGroup
     */
    public function __construct($startDate = null, $endDate = null, $name = null, \StructType\SocialSubGroup $socialSubGroup = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setName($name)
            ->setSocialSubGroup($socialSubGroup);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\SocialGroup
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\SocialGroup
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SocialGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SocialSubGroup value
     * @return \StructType\SocialSubGroup|null
     */
    public function getSocialSubGroup()
    {
        return $this->SocialSubGroup;
    }
    /**
     * Set SocialSubGroup value
     * @param \StructType\SocialSubGroup $socialSubGroup
     * @return \StructType\SocialGroup
     */
    public function setSocialSubGroup(\StructType\SocialSubGroup $socialSubGroup = null)
    {
        $this->SocialSubGroup = $socialSubGroup;
        return $this;
    }
}
