<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsCommunicationResult StructType
 * @subpackage Structs
 */
class SmsCommunicationResult extends ExecutionResult
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The SmsInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSmsInfoitem
     */
    public $SmsInfoList;
    /**
     * Constructor method for SmsCommunicationResult
     * @uses SmsCommunicationResult::setVehicle()
     * @uses SmsCommunicationResult::setTrailer()
     * @uses SmsCommunicationResult::setSmsInfoList()
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \ArrayType\ArrayOfSmsInfoitem $smsInfoList
     */
    public function __construct(\StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \ArrayType\ArrayOfSmsInfoitem $smsInfoList = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setSmsInfoList($smsInfoList);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\SmsCommunicationResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\SmsCommunicationResult
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get SmsInfoList value
     * @return \ArrayType\ArrayOfSmsInfoitem|null
     */
    public function getSmsInfoList()
    {
        return $this->SmsInfoList;
    }
    /**
     * Set SmsInfoList value
     * @param \ArrayType\ArrayOfSmsInfoitem $smsInfoList
     * @return \StructType\SmsCommunicationResult
     */
    public function setSmsInfoList(\ArrayType\ArrayOfSmsInfoitem $smsInfoList = null)
    {
        $this->SmsInfoList = $smsInfoList;
        return $this;
    }
}
