<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperResult_V2 StructType
 * @subpackage Structs
 */
class ShipperResult_V2 extends ShipperResult
{
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderReference;
    /**
     * Constructor method for ShipperResult_V2
     * @uses ShipperResult_V2::setOrderReference()
     * @param string $orderReference
     */
    public function __construct($orderReference = null)
    {
        $this
            ->setOrderReference($orderReference);
    }
    /**
     * Get OrderReference value
     * @return string|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param string $orderReference
     * @return \StructType\ShipperResult_V2
     */
    public function setOrderReference($orderReference = null)
    {
        // validation for constraint: string
        if (!is_null($orderReference) && !is_string($orderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderReference, true), gettype($orderReference)), __LINE__);
        }
        $this->OrderReference = $orderReference;
        return $this;
    }
}
