<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetTemperaturesSelection StructType
 * @subpackage Structs
 */
class SetTemperaturesSelection extends AbstractStructBase
{
    /**
     * The TemperatureSettingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TemperatureSettingType;
    /**
     * The FromDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FromDateTime;
    /**
     * The UntilDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UntilDateTime;
    /**
     * The UseTemperatureSensorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseTemperatureSensorConfig;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The TemperatureSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTemperatureSetting
     */
    public $TemperatureSettings;
    /**
     * Constructor method for SetTemperaturesSelection
     * @uses SetTemperaturesSelection::setTemperatureSettingType()
     * @uses SetTemperaturesSelection::setFromDateTime()
     * @uses SetTemperaturesSelection::setUntilDateTime()
     * @uses SetTemperaturesSelection::setUseTemperatureSensorConfig()
     * @uses SetTemperaturesSelection::setVehicles()
     * @uses SetTemperaturesSelection::setTrailers()
     * @uses SetTemperaturesSelection::setTemperatureSettings()
     * @param string $temperatureSettingType
     * @param string $fromDateTime
     * @param string $untilDateTime
     * @param bool $useTemperatureSensorConfig
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \ArrayType\ArrayOfTemperatureSetting $temperatureSettings
     */
    public function __construct($temperatureSettingType = null, $fromDateTime = null, $untilDateTime = null, $useTemperatureSensorConfig = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \ArrayType\ArrayOfTemperatureSetting $temperatureSettings = null)
    {
        $this
            ->setTemperatureSettingType($temperatureSettingType)
            ->setFromDateTime($fromDateTime)
            ->setUntilDateTime($untilDateTime)
            ->setUseTemperatureSensorConfig($useTemperatureSensorConfig)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setTemperatureSettings($temperatureSettings);
    }
    /**
     * Get TemperatureSettingType value
     * @return string
     */
    public function getTemperatureSettingType()
    {
        return $this->TemperatureSettingType;
    }
    /**
     * Set TemperatureSettingType value
     * @uses \EnumType\EnumTemperatureSettingType::valueIsValid()
     * @uses \EnumType\EnumTemperatureSettingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $temperatureSettingType
     * @return \StructType\SetTemperaturesSelection
     */
    public function setTemperatureSettingType($temperatureSettingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTemperatureSettingType::valueIsValid($temperatureSettingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTemperatureSettingType', is_array($temperatureSettingType) ? implode(', ', $temperatureSettingType) : var_export($temperatureSettingType, true), implode(', ', \EnumType\EnumTemperatureSettingType::getValidValues())), __LINE__);
        }
        $this->TemperatureSettingType = $temperatureSettingType;
        return $this;
    }
    /**
     * Get FromDateTime value
     * @return string
     */
    public function getFromDateTime()
    {
        return $this->FromDateTime;
    }
    /**
     * Set FromDateTime value
     * @param string $fromDateTime
     * @return \StructType\SetTemperaturesSelection
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateTime, true), gettype($fromDateTime)), __LINE__);
        }
        $this->FromDateTime = $fromDateTime;
        return $this;
    }
    /**
     * Get UntilDateTime value
     * @return string
     */
    public function getUntilDateTime()
    {
        return $this->UntilDateTime;
    }
    /**
     * Set UntilDateTime value
     * @param string $untilDateTime
     * @return \StructType\SetTemperaturesSelection
     */
    public function setUntilDateTime($untilDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($untilDateTime) && !is_string($untilDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDateTime, true), gettype($untilDateTime)), __LINE__);
        }
        $this->UntilDateTime = $untilDateTime;
        return $this;
    }
    /**
     * Get UseTemperatureSensorConfig value
     * @return bool
     */
    public function getUseTemperatureSensorConfig()
    {
        return $this->UseTemperatureSensorConfig;
    }
    /**
     * Set UseTemperatureSensorConfig value
     * @param bool $useTemperatureSensorConfig
     * @return \StructType\SetTemperaturesSelection
     */
    public function setUseTemperatureSensorConfig($useTemperatureSensorConfig = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTemperatureSensorConfig) && !is_bool($useTemperatureSensorConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useTemperatureSensorConfig, true), gettype($useTemperatureSensorConfig)), __LINE__);
        }
        $this->UseTemperatureSensorConfig = $useTemperatureSensorConfig;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\SetTemperaturesSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\SetTemperaturesSelection
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get TemperatureSettings value
     * @return \ArrayType\ArrayOfTemperatureSetting|null
     */
    public function getTemperatureSettings()
    {
        return $this->TemperatureSettings;
    }
    /**
     * Set TemperatureSettings value
     * @param \ArrayType\ArrayOfTemperatureSetting $temperatureSettings
     * @return \StructType\SetTemperaturesSelection
     */
    public function setTemperatureSettings(\ArrayType\ArrayOfTemperatureSetting $temperatureSettings = null)
    {
        $this->TemperatureSettings = $temperatureSettings;
        return $this;
    }
}
