<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceTimeTachoDetail_V2 StructType
 * @subpackage Structs
 */
class ServiceTimeTachoDetail_V2 extends AbstractStructBase
{
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The KmsEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmsEnd;
    /**
     * The KmsStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmsStart;
    /**
     * The ReadOutDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadOutDate;
    /**
     * The IsCoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCoDriver;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for ServiceTimeTachoDetail_V2
     * @uses ServiceTimeTachoDetail_V2::setBeginDate()
     * @uses ServiceTimeTachoDetail_V2::setEndDate()
     * @uses ServiceTimeTachoDetail_V2::setKmsEnd()
     * @uses ServiceTimeTachoDetail_V2::setKmsStart()
     * @uses ServiceTimeTachoDetail_V2::setReadOutDate()
     * @uses ServiceTimeTachoDetail_V2::setIsCoDriver()
     * @uses ServiceTimeTachoDetail_V2::setDriver()
     * @uses ServiceTimeTachoDetail_V2::setVehicle()
     * @uses ServiceTimeTachoDetail_V2::setWorkingCode()
     * @uses ServiceTimeTachoDetail_V2::setPosition()
     * @param string $beginDate
     * @param string $endDate
     * @param int $kmsEnd
     * @param int $kmsStart
     * @param string $readOutDate
     * @param bool $isCoDriver
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\PositionResult $position
     */
    public function __construct($beginDate = null, $endDate = null, $kmsEnd = null, $kmsStart = null, $readOutDate = null, $isCoDriver = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\CodeInfo $workingCode = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setKmsEnd($kmsEnd)
            ->setKmsStart($kmsStart)
            ->setReadOutDate($readOutDate)
            ->setIsCoDriver($isCoDriver)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setWorkingCode($workingCode)
            ->setPosition($position);
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get KmsEnd value
     * @return int
     */
    public function getKmsEnd()
    {
        return $this->KmsEnd;
    }
    /**
     * Set KmsEnd value
     * @param int $kmsEnd
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setKmsEnd($kmsEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmsEnd) && !(is_int($kmsEnd) || ctype_digit($kmsEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsEnd, true), gettype($kmsEnd)), __LINE__);
        }
        $this->KmsEnd = $kmsEnd;
        return $this;
    }
    /**
     * Get KmsStart value
     * @return int
     */
    public function getKmsStart()
    {
        return $this->KmsStart;
    }
    /**
     * Set KmsStart value
     * @param int $kmsStart
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setKmsStart($kmsStart = null)
    {
        // validation for constraint: int
        if (!is_null($kmsStart) && !(is_int($kmsStart) || ctype_digit($kmsStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsStart, true), gettype($kmsStart)), __LINE__);
        }
        $this->KmsStart = $kmsStart;
        return $this;
    }
    /**
     * Get ReadOutDate value
     * @return string
     */
    public function getReadOutDate()
    {
        return $this->ReadOutDate;
    }
    /**
     * Set ReadOutDate value
     * @param string $readOutDate
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setReadOutDate($readOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($readOutDate) && !is_string($readOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readOutDate, true), gettype($readOutDate)), __LINE__);
        }
        $this->ReadOutDate = $readOutDate;
        return $this;
    }
    /**
     * Get IsCoDriver value
     * @return bool
     */
    public function getIsCoDriver()
    {
        return $this->IsCoDriver;
    }
    /**
     * Set IsCoDriver value
     * @param bool $isCoDriver
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setIsCoDriver($isCoDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCoDriver) && !is_bool($isCoDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCoDriver, true), gettype($isCoDriver)), __LINE__);
        }
        $this->IsCoDriver = $isCoDriver;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\ServiceTimeTachoDetail_V2
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
