<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityCommand StructType
 * @subpackage Structs
 */
class SecurityCommand extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Trailer;
    /**
     * The MasterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterCode;
    /**
     * The VarioCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VarioCode;
    /**
     * Constructor method for SecurityCommand
     * @uses SecurityCommand::setVehicle()
     * @uses SecurityCommand::setTrailer()
     * @uses SecurityCommand::setMasterCode()
     * @uses SecurityCommand::setVarioCode()
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\IdentifierVehicle $trailer
     * @param string $masterCode
     * @param string $varioCode
     */
    public function __construct(\StructType\IdentifierVehicle $vehicle = null, \StructType\IdentifierVehicle $trailer = null, $masterCode = null, $varioCode = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setMasterCode($masterCode)
            ->setVarioCode($varioCode);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\SecurityCommand
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle $trailer
     * @return \StructType\SecurityCommand
     */
    public function setTrailer(\StructType\IdentifierVehicle $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get MasterCode value
     * @return string|null
     */
    public function getMasterCode()
    {
        return $this->MasterCode;
    }
    /**
     * Set MasterCode value
     * @param string $masterCode
     * @return \StructType\SecurityCommand
     */
    public function setMasterCode($masterCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterCode) && !is_string($masterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCode, true), gettype($masterCode)), __LINE__);
        }
        $this->MasterCode = $masterCode;
        return $this;
    }
    /**
     * Get VarioCode value
     * @return string|null
     */
    public function getVarioCode()
    {
        return $this->VarioCode;
    }
    /**
     * Set VarioCode value
     * @param string $varioCode
     * @return \StructType\SecurityCommand
     */
    public function setVarioCode($varioCode = null)
    {
        // validation for constraint: string
        if (!is_null($varioCode) && !is_string($varioCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($varioCode, true), gettype($varioCode)), __LINE__);
        }
        $this->VarioCode = $varioCode;
        return $this;
    }
}
