<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScannedDocumentsSelection_V3 StructType
 * @subpackage Structs
 */
class ScannedDocumentsSelection_V3 extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanID;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for ScannedDocumentsSelection_V3
     * @uses ScannedDocumentsSelection_V3::setScanID()
     * @uses ScannedDocumentsSelection_V3::setDateStrategySelection()
     * @param int $scanID
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($scanID = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setScanID($scanID)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\ScannedDocumentsSelection_V3
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !(is_int($scanID) || ctype_digit($scanID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scanID, true), gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\ScannedDocumentsSelection_V3
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
}
