<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalaryPreCalculationSelection_V2 StructType
 * @subpackage Structs
 */
class SalaryPreCalculationSelection_V2 extends AbstractStructBase
{
    /**
     * The SelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelectionType;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for SalaryPreCalculationSelection_V2
     * @uses SalaryPreCalculationSelection_V2::setSelectionType()
     * @uses SalaryPreCalculationSelection_V2::setDrivers()
     * @uses SalaryPreCalculationSelection_V2::setDateStrategySelection()
     * @param string $selectionType
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($selectionType = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setSelectionType($selectionType)
            ->setDrivers($drivers)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get SelectionType value
     * @return string
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @uses \EnumType\EnumSelectionType::valueIsValid()
     * @uses \EnumType\EnumSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSelectionType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSelectionType', is_array($selectionType) ? implode(', ', $selectionType) : var_export($selectionType, true), implode(', ', \EnumType\EnumSelectionType::getValidValues())), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
}
