<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemainingTimeItemMin StructType
 * @subpackage Structs
 */
class RemainingTimeItemMin extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Total;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Minimum;
    /**
     * The Remaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * Constructor method for RemainingTimeItemMin
     * @uses RemainingTimeItemMin::setTotal()
     * @uses RemainingTimeItemMin::setMinimum()
     * @uses RemainingTimeItemMin::setRemaining()
     * @param int $total
     * @param int $minimum
     * @param int $remaining
     */
    public function __construct($total = null, $minimum = null, $remaining = null)
    {
        $this
            ->setTotal($total)
            ->setMinimum($minimum)
            ->setRemaining($remaining);
    }
    /**
     * Get Total value
     * @return int
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\RemainingTimeItemMin
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Minimum value
     * @return int
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param int $minimum
     * @return \StructType\RemainingTimeItemMin
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: int
        if (!is_null($minimum) && !(is_int($minimum) || ctype_digit($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\RemainingTimeItemMin
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !(is_int($remaining) || ctype_digit($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
}
