<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemainingTimeItemMax StructType
 * @subpackage Structs
 */
class RemainingTimeItemMax extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Total;
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Maximum;
    /**
     * The Remaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * Constructor method for RemainingTimeItemMax
     * @uses RemainingTimeItemMax::setTotal()
     * @uses RemainingTimeItemMax::setMaximum()
     * @uses RemainingTimeItemMax::setRemaining()
     * @param int $total
     * @param int $maximum
     * @param int $remaining
     */
    public function __construct($total = null, $maximum = null, $remaining = null)
    {
        $this
            ->setTotal($total)
            ->setMaximum($maximum)
            ->setRemaining($remaining);
    }
    /**
     * Get Total value
     * @return int
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\RemainingTimeItemMax
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Maximum value
     * @return int
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param int $maximum
     * @return \StructType\RemainingTimeItemMax
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: int
        if (!is_null($maximum) && !(is_int($maximum) || ctype_digit($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\RemainingTimeItemMax
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !(is_int($remaining) || ctype_digit($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
}
