<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Registration_v2 StructType
 * @subpackage Structs
 */
class Registration_v2 extends AbstractStructBase
{
    /**
     * The Export
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Export;
    /**
     * The Consumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExportDate;
    /**
     * The Modified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The InterfaceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InterfaceInfo;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The KmsBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsBegin;
    /**
     * The kmsEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $kmsEnd;
    /**
     * The PlaceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceInfo;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The QuestionPathInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuestionPathInfo_v2
     */
    public $QuestionPathInfos;
    /**
     * Constructor method for Registration_v2
     * @uses Registration_v2::setExport()
     * @uses Registration_v2::setConsumption()
     * @uses Registration_v2::setBeginDate()
     * @uses Registration_v2::setEndDate()
     * @uses Registration_v2::setExportDate()
     * @uses Registration_v2::setModified()
     * @uses Registration_v2::setInterfaceInfo()
     * @uses Registration_v2::setSource()
     * @uses Registration_v2::setKmsBegin()
     * @uses Registration_v2::setKmsEnd()
     * @uses Registration_v2::setPlaceInfo()
     * @uses Registration_v2::setCountryCode()
     * @uses Registration_v2::setPosition()
     * @uses Registration_v2::setActivity()
     * @uses Registration_v2::setQuestionPathInfos()
     * @param bool $export
     * @param float $consumption
     * @param string $beginDate
     * @param string $endDate
     * @param string $exportDate
     * @param string $modified
     * @param int $interfaceInfo
     * @param string $source
     * @param int $kmsBegin
     * @param int $kmsEnd
     * @param string $placeInfo
     * @param string $countryCode
     * @param \StructType\Position $position
     * @param \StructType\Activity $activity
     * @param \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos
     */
    public function __construct($export = null, $consumption = null, $beginDate = null, $endDate = null, $exportDate = null, $modified = null, $interfaceInfo = null, $source = null, $kmsBegin = null, $kmsEnd = null, $placeInfo = null, $countryCode = null, \StructType\Position $position = null, \StructType\Activity $activity = null, \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos = null)
    {
        $this
            ->setExport($export)
            ->setConsumption($consumption)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setExportDate($exportDate)
            ->setModified($modified)
            ->setInterfaceInfo($interfaceInfo)
            ->setSource($source)
            ->setKmsBegin($kmsBegin)
            ->setKmsEnd($kmsEnd)
            ->setPlaceInfo($placeInfo)
            ->setCountryCode($countryCode)
            ->setPosition($position)
            ->setActivity($activity)
            ->setQuestionPathInfos($questionPathInfos);
    }
    /**
     * Get Export value
     * @return bool
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param bool $export
     * @return \StructType\Registration_v2
     */
    public function setExport($export = null)
    {
        // validation for constraint: boolean
        if (!is_null($export) && !is_bool($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\Registration_v2
     */
    public function setConsumption($consumption = null)
    {
        // validation for constraint: float
        if (!is_null($consumption) && !(is_float($consumption) || is_numeric($consumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption, true), gettype($consumption)), __LINE__);
        }
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\Registration_v2
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Registration_v2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExportDate value
     * @return string
     */
    public function getExportDate()
    {
        return $this->ExportDate;
    }
    /**
     * Set ExportDate value
     * @param string $exportDate
     * @return \StructType\Registration_v2
     */
    public function setExportDate($exportDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportDate) && !is_string($exportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDate, true), gettype($exportDate)), __LINE__);
        }
        $this->ExportDate = $exportDate;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\Registration_v2
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get InterfaceInfo value
     * @return int
     */
    public function getInterfaceInfo()
    {
        return $this->InterfaceInfo;
    }
    /**
     * Set InterfaceInfo value
     * @param int $interfaceInfo
     * @return \StructType\Registration_v2
     */
    public function setInterfaceInfo($interfaceInfo = null)
    {
        // validation for constraint: int
        if (!is_null($interfaceInfo) && !(is_int($interfaceInfo) || ctype_digit($interfaceInfo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interfaceInfo, true), gettype($interfaceInfo)), __LINE__);
        }
        $this->InterfaceInfo = $interfaceInfo;
        return $this;
    }
    /**
     * Get Source value
     * @return string
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @uses \EnumType\EnumRegistrationSource::valueIsValid()
     * @uses \EnumType\EnumRegistrationSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\Registration_v2
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumRegistrationSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumRegistrationSource', is_array($source) ? implode(', ', $source) : var_export($source, true), implode(', ', \EnumType\EnumRegistrationSource::getValidValues())), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get KmsBegin value
     * @return int
     */
    public function getKmsBegin()
    {
        return $this->KmsBegin;
    }
    /**
     * Set KmsBegin value
     * @param int $kmsBegin
     * @return \StructType\Registration_v2
     */
    public function setKmsBegin($kmsBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmsBegin) && !(is_int($kmsBegin) || ctype_digit($kmsBegin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsBegin, true), gettype($kmsBegin)), __LINE__);
        }
        $this->KmsBegin = $kmsBegin;
        return $this;
    }
    /**
     * Get kmsEnd value
     * @return int
     */
    public function getKmsEnd()
    {
        return $this->kmsEnd;
    }
    /**
     * Set kmsEnd value
     * @param int $kmsEnd
     * @return \StructType\Registration_v2
     */
    public function setKmsEnd($kmsEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmsEnd) && !(is_int($kmsEnd) || ctype_digit($kmsEnd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmsEnd, true), gettype($kmsEnd)), __LINE__);
        }
        $this->kmsEnd = $kmsEnd;
        return $this;
    }
    /**
     * Get PlaceInfo value
     * @return string|null
     */
    public function getPlaceInfo()
    {
        return $this->PlaceInfo;
    }
    /**
     * Set PlaceInfo value
     * @param string $placeInfo
     * @return \StructType\Registration_v2
     */
    public function setPlaceInfo($placeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($placeInfo) && !is_string($placeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeInfo, true), gettype($placeInfo)), __LINE__);
        }
        $this->PlaceInfo = $placeInfo;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Registration_v2
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\Registration_v2
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Registration_v2
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get QuestionPathInfos value
     * @return \ArrayType\ArrayOfQuestionPathInfo_v2|null
     */
    public function getQuestionPathInfos()
    {
        return $this->QuestionPathInfos;
    }
    /**
     * Set QuestionPathInfos value
     * @param \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos
     * @return \StructType\Registration_v2
     */
    public function setQuestionPathInfos(\ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos = null)
    {
        $this->QuestionPathInfos = $questionPathInfos;
        return $this;
    }
}
