<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceProduct StructType
 * @subpackage Structs
 */
class ReferenceProduct extends Reference
{
    /**
     * The AddresseeReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddresseeReference;
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientReference;
    /**
     * The Transporter1Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transporter1Reference;
    /**
     * The Transporter2Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transporter2Reference;
    /**
     * The Transporter3Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transporter3Reference;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The AddresseeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddresseeCode;
    /**
     * Constructor method for ReferenceProduct
     * @uses ReferenceProduct::setAddresseeReference()
     * @uses ReferenceProduct::setClientReference()
     * @uses ReferenceProduct::setTransporter1Reference()
     * @uses ReferenceProduct::setTransporter2Reference()
     * @uses ReferenceProduct::setTransporter3Reference()
     * @uses ReferenceProduct::setClientCode()
     * @uses ReferenceProduct::setAddresseeCode()
     * @param string $addresseeReference
     * @param string $clientReference
     * @param string $transporter1Reference
     * @param string $transporter2Reference
     * @param string $transporter3Reference
     * @param string $clientCode
     * @param string $addresseeCode
     */
    public function __construct($addresseeReference = null, $clientReference = null, $transporter1Reference = null, $transporter2Reference = null, $transporter3Reference = null, $clientCode = null, $addresseeCode = null)
    {
        $this
            ->setAddresseeReference($addresseeReference)
            ->setClientReference($clientReference)
            ->setTransporter1Reference($transporter1Reference)
            ->setTransporter2Reference($transporter2Reference)
            ->setTransporter3Reference($transporter3Reference)
            ->setClientCode($clientCode)
            ->setAddresseeCode($addresseeCode);
    }
    /**
     * Get AddresseeReference value
     * @return string|null
     */
    public function getAddresseeReference()
    {
        return $this->AddresseeReference;
    }
    /**
     * Set AddresseeReference value
     * @param string $addresseeReference
     * @return \StructType\ReferenceProduct
     */
    public function setAddresseeReference($addresseeReference = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeReference) && !is_string($addresseeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeReference, true), gettype($addresseeReference)), __LINE__);
        }
        $this->AddresseeReference = $addresseeReference;
        return $this;
    }
    /**
     * Get ClientReference value
     * @return string|null
     */
    public function getClientReference()
    {
        return $this->ClientReference;
    }
    /**
     * Set ClientReference value
     * @param string $clientReference
     * @return \StructType\ReferenceProduct
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        $this->ClientReference = $clientReference;
        return $this;
    }
    /**
     * Get Transporter1Reference value
     * @return string|null
     */
    public function getTransporter1Reference()
    {
        return $this->Transporter1Reference;
    }
    /**
     * Set Transporter1Reference value
     * @param string $transporter1Reference
     * @return \StructType\ReferenceProduct
     */
    public function setTransporter1Reference($transporter1Reference = null)
    {
        // validation for constraint: string
        if (!is_null($transporter1Reference) && !is_string($transporter1Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporter1Reference, true), gettype($transporter1Reference)), __LINE__);
        }
        $this->Transporter1Reference = $transporter1Reference;
        return $this;
    }
    /**
     * Get Transporter2Reference value
     * @return string|null
     */
    public function getTransporter2Reference()
    {
        return $this->Transporter2Reference;
    }
    /**
     * Set Transporter2Reference value
     * @param string $transporter2Reference
     * @return \StructType\ReferenceProduct
     */
    public function setTransporter2Reference($transporter2Reference = null)
    {
        // validation for constraint: string
        if (!is_null($transporter2Reference) && !is_string($transporter2Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporter2Reference, true), gettype($transporter2Reference)), __LINE__);
        }
        $this->Transporter2Reference = $transporter2Reference;
        return $this;
    }
    /**
     * Get Transporter3Reference value
     * @return string|null
     */
    public function getTransporter3Reference()
    {
        return $this->Transporter3Reference;
    }
    /**
     * Set Transporter3Reference value
     * @param string $transporter3Reference
     * @return \StructType\ReferenceProduct
     */
    public function setTransporter3Reference($transporter3Reference = null)
    {
        // validation for constraint: string
        if (!is_null($transporter3Reference) && !is_string($transporter3Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transporter3Reference, true), gettype($transporter3Reference)), __LINE__);
        }
        $this->Transporter3Reference = $transporter3Reference;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\ReferenceProduct
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get AddresseeCode value
     * @return string|null
     */
    public function getAddresseeCode()
    {
        return $this->AddresseeCode;
    }
    /**
     * Set AddresseeCode value
     * @param string $addresseeCode
     * @return \StructType\ReferenceProduct
     */
    public function setAddresseeCode($addresseeCode = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeCode) && !is_string($addresseeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeCode, true), gettype($addresseeCode)), __LINE__);
        }
        $this->AddresseeCode = $addresseeCode;
        return $this;
    }
}
