<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPMRangeItem StructType
 * @subpackage Structs
 */
class RPMRangeItem extends AbstractStructBase
{
    /**
     * The DistanceInKm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DistanceInKm;
    /**
     * The TotalFuelConsumptionInLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalFuelConsumptionInLiter;
    /**
     * The FuelConsumptionInLiterPer100km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInLiterPer100km;
    /**
     * The FuelConsumptionInkmPerLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInkmPerLiter;
    /**
     * The Rpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rpm;
    /**
     * Constructor method for RPMRangeItem
     * @uses RPMRangeItem::setDistanceInKm()
     * @uses RPMRangeItem::setTotalFuelConsumptionInLiter()
     * @uses RPMRangeItem::setFuelConsumptionInLiterPer100km()
     * @uses RPMRangeItem::setFuelConsumptionInkmPerLiter()
     * @uses RPMRangeItem::setRpm()
     * @param float $distanceInKm
     * @param float $totalFuelConsumptionInLiter
     * @param float $fuelConsumptionInLiterPer100km
     * @param float $fuelConsumptionInkmPerLiter
     * @param string $rpm
     */
    public function __construct($distanceInKm = null, $totalFuelConsumptionInLiter = null, $fuelConsumptionInLiterPer100km = null, $fuelConsumptionInkmPerLiter = null, $rpm = null)
    {
        $this
            ->setDistanceInKm($distanceInKm)
            ->setTotalFuelConsumptionInLiter($totalFuelConsumptionInLiter)
            ->setFuelConsumptionInLiterPer100km($fuelConsumptionInLiterPer100km)
            ->setFuelConsumptionInkmPerLiter($fuelConsumptionInkmPerLiter)
            ->setRpm($rpm);
    }
    /**
     * Get DistanceInKm value
     * @return float
     */
    public function getDistanceInKm()
    {
        return $this->DistanceInKm;
    }
    /**
     * Set DistanceInKm value
     * @param float $distanceInKm
     * @return \StructType\RPMRangeItem
     */
    public function setDistanceInKm($distanceInKm = null)
    {
        // validation for constraint: float
        if (!is_null($distanceInKm) && !(is_float($distanceInKm) || is_numeric($distanceInKm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceInKm, true), gettype($distanceInKm)), __LINE__);
        }
        $this->DistanceInKm = $distanceInKm;
        return $this;
    }
    /**
     * Get TotalFuelConsumptionInLiter value
     * @return float
     */
    public function getTotalFuelConsumptionInLiter()
    {
        return $this->TotalFuelConsumptionInLiter;
    }
    /**
     * Set TotalFuelConsumptionInLiter value
     * @param float $totalFuelConsumptionInLiter
     * @return \StructType\RPMRangeItem
     */
    public function setTotalFuelConsumptionInLiter($totalFuelConsumptionInLiter = null)
    {
        // validation for constraint: float
        if (!is_null($totalFuelConsumptionInLiter) && !(is_float($totalFuelConsumptionInLiter) || is_numeric($totalFuelConsumptionInLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFuelConsumptionInLiter, true), gettype($totalFuelConsumptionInLiter)), __LINE__);
        }
        $this->TotalFuelConsumptionInLiter = $totalFuelConsumptionInLiter;
        return $this;
    }
    /**
     * Get FuelConsumptionInLiterPer100km value
     * @return float
     */
    public function getFuelConsumptionInLiterPer100km()
    {
        return $this->FuelConsumptionInLiterPer100km;
    }
    /**
     * Set FuelConsumptionInLiterPer100km value
     * @param float $fuelConsumptionInLiterPer100km
     * @return \StructType\RPMRangeItem
     */
    public function setFuelConsumptionInLiterPer100km($fuelConsumptionInLiterPer100km = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInLiterPer100km) && !(is_float($fuelConsumptionInLiterPer100km) || is_numeric($fuelConsumptionInLiterPer100km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInLiterPer100km, true), gettype($fuelConsumptionInLiterPer100km)), __LINE__);
        }
        $this->FuelConsumptionInLiterPer100km = $fuelConsumptionInLiterPer100km;
        return $this;
    }
    /**
     * Get FuelConsumptionInkmPerLiter value
     * @return float
     */
    public function getFuelConsumptionInkmPerLiter()
    {
        return $this->FuelConsumptionInkmPerLiter;
    }
    /**
     * Set FuelConsumptionInkmPerLiter value
     * @param float $fuelConsumptionInkmPerLiter
     * @return \StructType\RPMRangeItem
     */
    public function setFuelConsumptionInkmPerLiter($fuelConsumptionInkmPerLiter = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInkmPerLiter) && !(is_float($fuelConsumptionInkmPerLiter) || is_numeric($fuelConsumptionInkmPerLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInkmPerLiter, true), gettype($fuelConsumptionInkmPerLiter)), __LINE__);
        }
        $this->FuelConsumptionInkmPerLiter = $fuelConsumptionInkmPerLiter;
        return $this;
    }
    /**
     * Get Rpm value
     * @return string|null
     */
    public function getRpm()
    {
        return $this->Rpm;
    }
    /**
     * Set Rpm value
     * @param string $rpm
     * @return \StructType\RPMRangeItem
     */
    public function setRpm($rpm = null)
    {
        // validation for constraint: string
        if (!is_null($rpm) && !is_string($rpm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rpm, true), gettype($rpm)), __LINE__);
        }
        $this->Rpm = $rpm;
        return $this;
    }
}
