<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuestionPathInfo_v2 StructType
 * @subpackage Structs
 */
class QuestionPathInfo_v2 extends AbstractStructBase
{
    /**
     * The QuestionPathType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QuestionPathType;
    /**
     * The AutoClosed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoClosed;
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer;
    /**
     * The TreatmentCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $TreatmentCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AnswerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnswerID;
    /**
     * The QuestionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionID;
    /**
     * Constructor method for QuestionPathInfo_v2
     * @uses QuestionPathInfo_v2::setQuestionPathType()
     * @uses QuestionPathInfo_v2::setAutoClosed()
     * @uses QuestionPathInfo_v2::setAnswer()
     * @uses QuestionPathInfo_v2::setTreatmentCode()
     * @uses QuestionPathInfo_v2::setDescription()
     * @uses QuestionPathInfo_v2::setAnswerID()
     * @uses QuestionPathInfo_v2::setQuestionID()
     * @param int $questionPathType
     * @param bool $autoClosed
     * @param string $answer
     * @param \StructType\CodeInfo $treatmentCode
     * @param string $description
     * @param string $answerID
     * @param string $questionID
     */
    public function __construct($questionPathType = null, $autoClosed = null, $answer = null, \StructType\CodeInfo $treatmentCode = null, $description = null, $answerID = null, $questionID = null)
    {
        $this
            ->setQuestionPathType($questionPathType)
            ->setAutoClosed($autoClosed)
            ->setAnswer($answer)
            ->setTreatmentCode($treatmentCode)
            ->setDescription($description)
            ->setAnswerID($answerID)
            ->setQuestionID($questionID);
    }
    /**
     * Get QuestionPathType value
     * @return int
     */
    public function getQuestionPathType()
    {
        return $this->QuestionPathType;
    }
    /**
     * Set QuestionPathType value
     * @param int $questionPathType
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setQuestionPathType($questionPathType = null)
    {
        // validation for constraint: int
        if (!is_null($questionPathType) && !(is_int($questionPathType) || ctype_digit($questionPathType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($questionPathType, true), gettype($questionPathType)), __LINE__);
        }
        $this->QuestionPathType = $questionPathType;
        return $this;
    }
    /**
     * Get AutoClosed value
     * @return bool
     */
    public function getAutoClosed()
    {
        return $this->AutoClosed;
    }
    /**
     * Set AutoClosed value
     * @param bool $autoClosed
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setAutoClosed($autoClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoClosed) && !is_bool($autoClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoClosed, true), gettype($autoClosed)), __LINE__);
        }
        $this->AutoClosed = $autoClosed;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Get TreatmentCode value
     * @return \StructType\CodeInfo|null
     */
    public function getTreatmentCode()
    {
        return $this->TreatmentCode;
    }
    /**
     * Set TreatmentCode value
     * @param \StructType\CodeInfo $treatmentCode
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setTreatmentCode(\StructType\CodeInfo $treatmentCode = null)
    {
        $this->TreatmentCode = $treatmentCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AnswerID value
     * @return string|null
     */
    public function getAnswerID()
    {
        return $this->AnswerID;
    }
    /**
     * Set AnswerID value
     * @param string $answerID
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setAnswerID($answerID = null)
    {
        // validation for constraint: string
        if (!is_null($answerID) && !is_string($answerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerID, true), gettype($answerID)), __LINE__);
        }
        $this->AnswerID = $answerID;
        return $this;
    }
    /**
     * Get QuestionID value
     * @return string|null
     */
    public function getQuestionID()
    {
        return $this->QuestionID;
    }
    /**
     * Set QuestionID value
     * @param string $questionID
     * @return \StructType\QuestionPathInfo_v2
     */
    public function setQuestionID($questionID = null)
    {
        // validation for constraint: string
        if (!is_null($questionID) && !is_string($questionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionID, true), gettype($questionID)), __LINE__);
        }
        $this->QuestionID = $questionID;
        return $this;
    }
}
