<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PushedMessagesSelection StructType
 * @subpackage Structs
 */
class PushedMessagesSelection extends AbstractStructBase
{
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDateTime;
    /**
     * The TypeOfMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfMessages;
    /**
     * Constructor method for PushedMessagesSelection
     * @uses PushedMessagesSelection::setStartDateTime()
     * @uses PushedMessagesSelection::setEndDateTime()
     * @uses PushedMessagesSelection::setTypeOfMessages()
     * @param string $startDateTime
     * @param string $endDateTime
     * @param string $typeOfMessages
     */
    public function __construct($startDateTime = null, $endDateTime = null, $typeOfMessages = null)
    {
        $this
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setTypeOfMessages($typeOfMessages);
    }
    /**
     * Get StartDateTime value
     * @return string
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\PushedMessagesSelection
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\PushedMessagesSelection
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get TypeOfMessages value
     * @return string|null
     */
    public function getTypeOfMessages()
    {
        return $this->TypeOfMessages;
    }
    /**
     * Set TypeOfMessages value
     * @param string $typeOfMessages
     * @return \StructType\PushedMessagesSelection
     */
    public function setTypeOfMessages($typeOfMessages = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfMessages) && !is_string($typeOfMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfMessages, true), gettype($typeOfMessages)), __LINE__);
        }
        $this->TypeOfMessages = $typeOfMessages;
        return $this;
    }
}
