<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResult StructType
 * @subpackage Structs
 */
class ProductResult extends Product
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * The CreatedByDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CreatedByDriver;
    /**
     * The Export
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Export;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ModificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationNumber;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The PalletInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $ExtraInfos;
    /**
     * The Transfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transfer
     */
    public $Transfer;
    /**
     * Constructor method for ProductResult
     * @uses ProductResult::setStatus()
     * @uses ProductResult::setExternalSynchStatus()
     * @uses ProductResult::setCancelStatus()
     * @uses ProductResult::setProductType()
     * @uses ProductResult::setCreatedByDriver()
     * @uses ProductResult::setExport()
     * @uses ProductResult::setModificationDate()
     * @uses ProductResult::setModificationNumber()
     * @uses ProductResult::setAuthor()
     * @uses ProductResult::setFormat()
     * @uses ProductResult::setAnomalies()
     * @uses ProductResult::setPalletInfos()
     * @uses ProductResult::setExtraInfos()
     * @uses ProductResult::setTransfer()
     * @param string $status
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param int $productType
     * @param bool $createdByDriver
     * @param int $export
     * @param string $modificationDate
     * @param int $modificationNumber
     * @param string $author
     * @param string $format
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @param \StructType\Transfer $transfer
     */
    public function __construct($status = null, $externalSynchStatus = null, $cancelStatus = null, $productType = null, $createdByDriver = null, $export = null, $modificationDate = null, $modificationNumber = null, $author = null, $format = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfExtraInfo $palletInfos = null, \ArrayType\ArrayOfExtraInfo $extraInfos = null, \StructType\Transfer $transfer = null)
    {
        $this
            ->setStatus($status)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setProductType($productType)
            ->setCreatedByDriver($createdByDriver)
            ->setExport($export)
            ->setModificationDate($modificationDate)
            ->setModificationNumber($modificationNumber)
            ->setAuthor($author)
            ->setFormat($format)
            ->setAnomalies($anomalies)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setTransfer($transfer);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ProductResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\ProductResult
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\ProductResult
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get ProductType value
     * @return int
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param int $productType
     * @return \StructType\ProductResult
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !(is_int($productType) || ctype_digit($productType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get CreatedByDriver value
     * @return bool
     */
    public function getCreatedByDriver()
    {
        return $this->CreatedByDriver;
    }
    /**
     * Set CreatedByDriver value
     * @param bool $createdByDriver
     * @return \StructType\ProductResult
     */
    public function setCreatedByDriver($createdByDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdByDriver) && !is_bool($createdByDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdByDriver, true), gettype($createdByDriver)), __LINE__);
        }
        $this->CreatedByDriver = $createdByDriver;
        return $this;
    }
    /**
     * Get Export value
     * @return int
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param int $export
     * @return \StructType\ProductResult
     */
    public function setExport($export = null)
    {
        // validation for constraint: int
        if (!is_null($export) && !(is_int($export) || ctype_digit($export))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\ProductResult
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ModificationNumber value
     * @return int
     */
    public function getModificationNumber()
    {
        return $this->ModificationNumber;
    }
    /**
     * Set ModificationNumber value
     * @param int $modificationNumber
     * @return \StructType\ProductResult
     */
    public function setModificationNumber($modificationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($modificationNumber) && !(is_int($modificationNumber) || ctype_digit($modificationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationNumber, true), gettype($modificationNumber)), __LINE__);
        }
        $this->ModificationNumber = $modificationNumber;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\ProductResult
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\ProductResult
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\ProductResult
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @return \StructType\ProductResult
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @return \StructType\ProductResult
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get Transfer value
     * @return \StructType\Transfer|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @param \StructType\Transfer $transfer
     * @return \StructType\ProductResult
     */
    public function setTransfer(\StructType\Transfer $transfer = null)
    {
        $this->Transfer = $transfer;
        return $this;
    }
}
