<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductItemResult_V3 StructType
 * @subpackage Structs
 */
class ProductItemResult_V3 extends ProductItemResult_V2
{
    /**
     * The CheckoffType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckoffType;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * Constructor method for ProductItemResult_V3
     * @uses ProductItemResult_V3::setCheckoffType()
     * @uses ProductItemResult_V3::setProductType()
     * @param string $checkoffType
     * @param int $productType
     */
    public function __construct($checkoffType = null, $productType = null)
    {
        $this
            ->setCheckoffType($checkoffType)
            ->setProductType($productType);
    }
    /**
     * Get CheckoffType value
     * @return string
     */
    public function getCheckoffType()
    {
        return $this->CheckoffType;
    }
    /**
     * Set CheckoffType value
     * @uses \EnumType\EnumCheckOffType::valueIsValid()
     * @uses \EnumType\EnumCheckOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkoffType
     * @return \StructType\ProductItemResult_V3
     */
    public function setCheckoffType($checkoffType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCheckOffType::valueIsValid($checkoffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCheckOffType', is_array($checkoffType) ? implode(', ', $checkoffType) : var_export($checkoffType, true), implode(', ', \EnumType\EnumCheckOffType::getValidValues())), __LINE__);
        }
        $this->CheckoffType = $checkoffType;
        return $this;
    }
    /**
     * Get ProductType value
     * @return int
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param int $productType
     * @return \StructType\ProductItemResult_V3
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !(is_int($productType) || ctype_digit($productType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
}
