<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInsert StructType
 * @subpackage Structs
 */
class ProductInsert extends Product
{
    /**
     * The ProductCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProductCategory;
    /**
     * The PlanningConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for ProductInsert
     * @uses ProductInsert::setProductCategory()
     * @uses ProductInsert::setPlanningConfig()
     * @param int $productCategory
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct($productCategory = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setProductCategory($productCategory)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get ProductCategory value
     * @return int
     */
    public function getProductCategory()
    {
        return $this->ProductCategory;
    }
    /**
     * Set ProductCategory value
     * @param int $productCategory
     * @return \StructType\ProductInsert
     */
    public function setProductCategory($productCategory = null)
    {
        // validation for constraint: int
        if (!is_null($productCategory) && !(is_int($productCategory) || ctype_digit($productCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCategory, true), gettype($productCategory)), __LINE__);
        }
        $this->ProductCategory = $productCategory;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\ProductInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
}
