<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionSelection_V2 StructType
 * @subpackage Structs
 */
class PositionSelection_V2 extends AbstractStructBase
{
    /**
     * The ExcludeActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeActivities;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeriodSelectionWithDateType
     */
    public $DateTimeRangeSelection;
    /**
     * The DateTimeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $DateTimeSelection;
    /**
     * Constructor method for PositionSelection_V2
     * @uses PositionSelection_V2::setExcludeActivities()
     * @uses PositionSelection_V2::setDrivers()
     * @uses PositionSelection_V2::setVehicles()
     * @uses PositionSelection_V2::setTrailers()
     * @uses PositionSelection_V2::setDateTimeRangeSelection()
     * @uses PositionSelection_V2::setDateTimeSelection()
     * @param bool $excludeActivities
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @param \StructType\DateTimeSelection $dateTimeSelection
     */
    public function __construct($excludeActivities = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null, \StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this
            ->setExcludeActivities($excludeActivities)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDateTimeSelection($dateTimeSelection);
    }
    /**
     * Get ExcludeActivities value
     * @return bool
     */
    public function getExcludeActivities()
    {
        return $this->ExcludeActivities;
    }
    /**
     * Set ExcludeActivities value
     * @param bool $excludeActivities
     * @return \StructType\PositionSelection_V2
     */
    public function setExcludeActivities($excludeActivities = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeActivities) && !is_bool($excludeActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeActivities, true), gettype($excludeActivities)), __LINE__);
        }
        $this->ExcludeActivities = $excludeActivities;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\PositionSelection_V2
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\PositionSelection_V2
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\PositionSelection_V2
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\PeriodSelectionWithDateType|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @return \StructType\PositionSelection_V2
     */
    public function setDateTimeRangeSelection(\StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get DateTimeSelection value
     * @return \StructType\DateTimeSelection|null
     */
    public function getDateTimeSelection()
    {
        return $this->DateTimeSelection;
    }
    /**
     * Set DateTimeSelection value
     * @param \StructType\DateTimeSelection $dateTimeSelection
     * @return \StructType\PositionSelection_V2
     */
    public function setDateTimeSelection(\StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this->DateTimeSelection = $dateTimeSelection;
        return $this;
    }
}
