<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionResult_V4 StructType
 * @subpackage Structs
 */
class PositionResult_V4 extends PositionResult_V3
{
    /**
     * The LocationSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LocationSource;
    /**
     * Constructor method for PositionResult_V4
     * @uses PositionResult_V4::setLocationSource()
     * @param string $locationSource
     */
    public function __construct($locationSource = null)
    {
        $this
            ->setLocationSource($locationSource);
    }
    /**
     * Get LocationSource value
     * @return string
     */
    public function getLocationSource()
    {
        return $this->LocationSource;
    }
    /**
     * Set LocationSource value
     * @uses \EnumType\EnumPositionSource::valueIsValid()
     * @uses \EnumType\EnumPositionSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locationSource
     * @return \StructType\PositionResult_V4
     */
    public function setLocationSource($locationSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPositionSource::valueIsValid($locationSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPositionSource', is_array($locationSource) ? implode(', ', $locationSource) : var_export($locationSource, true), implode(', ', \EnumType\EnumPositionSource::getValidValues())), __LINE__);
        }
        $this->LocationSource = $locationSource;
        return $this;
    }
}
