<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionResult StructType
 * @subpackage Structs
 */
class PositionResult extends Position
{
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The DistanceFromCapitol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromCapitol;
    /**
     * The DistanceFromLargeCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromLargeCity;
    /**
     * The DistanceFromSmallCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromSmallCity;
    /**
     * The DistanceFromPointOfInterest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromPointOfInterest;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for PositionResult
     * @uses PositionResult::setAddressInfo()
     * @uses PositionResult::setDistanceFromCapitol()
     * @uses PositionResult::setDistanceFromLargeCity()
     * @uses PositionResult::setDistanceFromSmallCity()
     * @uses PositionResult::setDistanceFromPointOfInterest()
     * @uses PositionResult::setCountryCode()
     * @param string $addressInfo
     * @param string $distanceFromCapitol
     * @param string $distanceFromLargeCity
     * @param string $distanceFromSmallCity
     * @param string $distanceFromPointOfInterest
     * @param string $countryCode
     */
    public function __construct($addressInfo = null, $distanceFromCapitol = null, $distanceFromLargeCity = null, $distanceFromSmallCity = null, $distanceFromPointOfInterest = null, $countryCode = null)
    {
        $this
            ->setAddressInfo($addressInfo)
            ->setDistanceFromCapitol($distanceFromCapitol)
            ->setDistanceFromLargeCity($distanceFromLargeCity)
            ->setDistanceFromSmallCity($distanceFromSmallCity)
            ->setDistanceFromPointOfInterest($distanceFromPointOfInterest)
            ->setCountryCode($countryCode);
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\PositionResult
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressInfo, true), gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get DistanceFromCapitol value
     * @return string|null
     */
    public function getDistanceFromCapitol()
    {
        return $this->DistanceFromCapitol;
    }
    /**
     * Set DistanceFromCapitol value
     * @param string $distanceFromCapitol
     * @return \StructType\PositionResult
     */
    public function setDistanceFromCapitol($distanceFromCapitol = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromCapitol) && !is_string($distanceFromCapitol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromCapitol, true), gettype($distanceFromCapitol)), __LINE__);
        }
        $this->DistanceFromCapitol = $distanceFromCapitol;
        return $this;
    }
    /**
     * Get DistanceFromLargeCity value
     * @return string|null
     */
    public function getDistanceFromLargeCity()
    {
        return $this->DistanceFromLargeCity;
    }
    /**
     * Set DistanceFromLargeCity value
     * @param string $distanceFromLargeCity
     * @return \StructType\PositionResult
     */
    public function setDistanceFromLargeCity($distanceFromLargeCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromLargeCity) && !is_string($distanceFromLargeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromLargeCity, true), gettype($distanceFromLargeCity)), __LINE__);
        }
        $this->DistanceFromLargeCity = $distanceFromLargeCity;
        return $this;
    }
    /**
     * Get DistanceFromSmallCity value
     * @return string|null
     */
    public function getDistanceFromSmallCity()
    {
        return $this->DistanceFromSmallCity;
    }
    /**
     * Set DistanceFromSmallCity value
     * @param string $distanceFromSmallCity
     * @return \StructType\PositionResult
     */
    public function setDistanceFromSmallCity($distanceFromSmallCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromSmallCity) && !is_string($distanceFromSmallCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromSmallCity, true), gettype($distanceFromSmallCity)), __LINE__);
        }
        $this->DistanceFromSmallCity = $distanceFromSmallCity;
        return $this;
    }
    /**
     * Get DistanceFromPointOfInterest value
     * @return string|null
     */
    public function getDistanceFromPointOfInterest()
    {
        return $this->DistanceFromPointOfInterest;
    }
    /**
     * Set DistanceFromPointOfInterest value
     * @param string $distanceFromPointOfInterest
     * @return \StructType\PositionResult
     */
    public function setDistanceFromPointOfInterest($distanceFromPointOfInterest = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromPointOfInterest) && !is_string($distanceFromPointOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromPointOfInterest, true), gettype($distanceFromPointOfInterest)), __LINE__);
        }
        $this->DistanceFromPointOfInterest = $distanceFromPointOfInterest;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\PositionResult
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
