<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionItemResult_V7 StructType
 * @subpackage Structs
 */
class PositionItemResult_V7 extends Position
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Kms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kms;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Speed;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FuelLevel;
    /**
     * The Heading
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Heading;
    /**
     * The AdBlueLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AdBlueLevel;
    /**
     * The TotalFuelUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalFuelUsed;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The SynchronizationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SynchronizationId;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo
     */
    public $Activity;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The DistanceFromCapitol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromCapitol;
    /**
     * The DistanceFromLargeCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromLargeCity;
    /**
     * The DistanceFromSmallCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromSmallCity;
    /**
     * The DistanceFromPointOfInterest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromPointOfInterest;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $Country;
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataSource;
    /**
     * Constructor method for PositionItemResult_V7
     * @uses PositionItemResult_V7::setDateTime()
     * @uses PositionItemResult_V7::setKms()
     * @uses PositionItemResult_V7::setSpeed()
     * @uses PositionItemResult_V7::setFuelLevel()
     * @uses PositionItemResult_V7::setHeading()
     * @uses PositionItemResult_V7::setAdBlueLevel()
     * @uses PositionItemResult_V7::setTotalFuelUsed()
     * @uses PositionItemResult_V7::setSynchronizationDate()
     * @uses PositionItemResult_V7::setSynchronizationId()
     * @uses PositionItemResult_V7::setVehicle()
     * @uses PositionItemResult_V7::setTrailer()
     * @uses PositionItemResult_V7::setDriver()
     * @uses PositionItemResult_V7::setCoDriver()
     * @uses PositionItemResult_V7::setActivity()
     * @uses PositionItemResult_V7::setAddressInfo()
     * @uses PositionItemResult_V7::setDistanceFromCapitol()
     * @uses PositionItemResult_V7::setDistanceFromLargeCity()
     * @uses PositionItemResult_V7::setDistanceFromSmallCity()
     * @uses PositionItemResult_V7::setDistanceFromPointOfInterest()
     * @uses PositionItemResult_V7::setCountry()
     * @uses PositionItemResult_V7::setDataSource()
     * @param string $dateTime
     * @param int $kms
     * @param float $speed
     * @param int $fuelLevel
     * @param int $heading
     * @param int $adBlueLevel
     * @param int $totalFuelUsed
     * @param string $synchronizationDate
     * @param int $synchronizationId
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param \StructType\ActivityInfo $activity
     * @param string $addressInfo
     * @param string $distanceFromCapitol
     * @param string $distanceFromLargeCity
     * @param string $distanceFromSmallCity
     * @param string $distanceFromPointOfInterest
     * @param \StructType\Country $country
     * @param string $dataSource
     */
    public function __construct($dateTime = null, $kms = null, $speed = null, $fuelLevel = null, $heading = null, $adBlueLevel = null, $totalFuelUsed = null, $synchronizationDate = null, $synchronizationId = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, \StructType\ActivityInfo $activity = null, $addressInfo = null, $distanceFromCapitol = null, $distanceFromLargeCity = null, $distanceFromSmallCity = null, $distanceFromPointOfInterest = null, \StructType\Country $country = null, $dataSource = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setKms($kms)
            ->setSpeed($speed)
            ->setFuelLevel($fuelLevel)
            ->setHeading($heading)
            ->setAdBlueLevel($adBlueLevel)
            ->setTotalFuelUsed($totalFuelUsed)
            ->setSynchronizationDate($synchronizationDate)
            ->setSynchronizationId($synchronizationId)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setActivity($activity)
            ->setAddressInfo($addressInfo)
            ->setDistanceFromCapitol($distanceFromCapitol)
            ->setDistanceFromLargeCity($distanceFromLargeCity)
            ->setDistanceFromSmallCity($distanceFromSmallCity)
            ->setDistanceFromPointOfInterest($distanceFromPointOfInterest)
            ->setCountry($country)
            ->setDataSource($dataSource);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\PositionItemResult_V7
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Kms value
     * @return int
     */
    public function getKms()
    {
        return $this->Kms;
    }
    /**
     * Set Kms value
     * @param int $kms
     * @return \StructType\PositionItemResult_V7
     */
    public function setKms($kms = null)
    {
        // validation for constraint: int
        if (!is_null($kms) && !(is_int($kms) || ctype_digit($kms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kms, true), gettype($kms)), __LINE__);
        }
        $this->Kms = $kms;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\PositionItemResult_V7
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: float
        if (!is_null($speed) && !(is_float($speed) || is_numeric($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\PositionItemResult_V7
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get Heading value
     * @return int
     */
    public function getHeading()
    {
        return $this->Heading;
    }
    /**
     * Set Heading value
     * @param int $heading
     * @return \StructType\PositionItemResult_V7
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: int
        if (!is_null($heading) && !(is_int($heading) || ctype_digit($heading))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heading, true), gettype($heading)), __LINE__);
        }
        $this->Heading = $heading;
        return $this;
    }
    /**
     * Get AdBlueLevel value
     * @return int
     */
    public function getAdBlueLevel()
    {
        return $this->AdBlueLevel;
    }
    /**
     * Set AdBlueLevel value
     * @param int $adBlueLevel
     * @return \StructType\PositionItemResult_V7
     */
    public function setAdBlueLevel($adBlueLevel = null)
    {
        // validation for constraint: int
        if (!is_null($adBlueLevel) && !(is_int($adBlueLevel) || ctype_digit($adBlueLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adBlueLevel, true), gettype($adBlueLevel)), __LINE__);
        }
        $this->AdBlueLevel = $adBlueLevel;
        return $this;
    }
    /**
     * Get TotalFuelUsed value
     * @return int
     */
    public function getTotalFuelUsed()
    {
        return $this->TotalFuelUsed;
    }
    /**
     * Set TotalFuelUsed value
     * @param int $totalFuelUsed
     * @return \StructType\PositionItemResult_V7
     */
    public function setTotalFuelUsed($totalFuelUsed = null)
    {
        // validation for constraint: int
        if (!is_null($totalFuelUsed) && !(is_int($totalFuelUsed) || ctype_digit($totalFuelUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalFuelUsed, true), gettype($totalFuelUsed)), __LINE__);
        }
        $this->TotalFuelUsed = $totalFuelUsed;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\PositionItemResult_V7
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get SynchronizationId value
     * @return int
     */
    public function getSynchronizationId()
    {
        return $this->SynchronizationId;
    }
    /**
     * Set SynchronizationId value
     * @param int $synchronizationId
     * @return \StructType\PositionItemResult_V7
     */
    public function setSynchronizationId($synchronizationId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationId) && !(is_int($synchronizationId) || ctype_digit($synchronizationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($synchronizationId, true), gettype($synchronizationId)), __LINE__);
        }
        $this->SynchronizationId = $synchronizationId;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\PositionItemResult_V7
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\PositionItemResult_V7
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\PositionItemResult_V7
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\PositionItemResult_V7
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo $activity
     * @return \StructType\PositionItemResult_V7
     */
    public function setActivity(\StructType\ActivityInfo $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\PositionItemResult_V7
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressInfo, true), gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get DistanceFromCapitol value
     * @return string|null
     */
    public function getDistanceFromCapitol()
    {
        return $this->DistanceFromCapitol;
    }
    /**
     * Set DistanceFromCapitol value
     * @param string $distanceFromCapitol
     * @return \StructType\PositionItemResult_V7
     */
    public function setDistanceFromCapitol($distanceFromCapitol = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromCapitol) && !is_string($distanceFromCapitol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromCapitol, true), gettype($distanceFromCapitol)), __LINE__);
        }
        $this->DistanceFromCapitol = $distanceFromCapitol;
        return $this;
    }
    /**
     * Get DistanceFromLargeCity value
     * @return string|null
     */
    public function getDistanceFromLargeCity()
    {
        return $this->DistanceFromLargeCity;
    }
    /**
     * Set DistanceFromLargeCity value
     * @param string $distanceFromLargeCity
     * @return \StructType\PositionItemResult_V7
     */
    public function setDistanceFromLargeCity($distanceFromLargeCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromLargeCity) && !is_string($distanceFromLargeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromLargeCity, true), gettype($distanceFromLargeCity)), __LINE__);
        }
        $this->DistanceFromLargeCity = $distanceFromLargeCity;
        return $this;
    }
    /**
     * Get DistanceFromSmallCity value
     * @return string|null
     */
    public function getDistanceFromSmallCity()
    {
        return $this->DistanceFromSmallCity;
    }
    /**
     * Set DistanceFromSmallCity value
     * @param string $distanceFromSmallCity
     * @return \StructType\PositionItemResult_V7
     */
    public function setDistanceFromSmallCity($distanceFromSmallCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromSmallCity) && !is_string($distanceFromSmallCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromSmallCity, true), gettype($distanceFromSmallCity)), __LINE__);
        }
        $this->DistanceFromSmallCity = $distanceFromSmallCity;
        return $this;
    }
    /**
     * Get DistanceFromPointOfInterest value
     * @return string|null
     */
    public function getDistanceFromPointOfInterest()
    {
        return $this->DistanceFromPointOfInterest;
    }
    /**
     * Set DistanceFromPointOfInterest value
     * @param string $distanceFromPointOfInterest
     * @return \StructType\PositionItemResult_V7
     */
    public function setDistanceFromPointOfInterest($distanceFromPointOfInterest = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromPointOfInterest) && !is_string($distanceFromPointOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceFromPointOfInterest, true), gettype($distanceFromPointOfInterest)), __LINE__);
        }
        $this->DistanceFromPointOfInterest = $distanceFromPointOfInterest;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\Country $country
     * @return \StructType\PositionItemResult_V7
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get DataSource value
     * @return string|null
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @param string $dataSource
     * @return \StructType\PositionItemResult_V7
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: string
        if (!is_null($dataSource) && !is_string($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSource, true), gettype($dataSource)), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
}
