<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionAreaSelection StructType
 * @subpackage Structs
 */
class PositionAreaSelection extends AbstractStructBase
{
    /**
     * The KmsAround
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KmsAround;
    /**
     * The AreaType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AreaType;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for PositionAreaSelection
     * @uses PositionAreaSelection::setKmsAround()
     * @uses PositionAreaSelection::setAreaType()
     * @uses PositionAreaSelection::setDriver()
     * @uses PositionAreaSelection::setVehicle()
     * @uses PositionAreaSelection::setDateTimeRange()
     * @uses PositionAreaSelection::setSelectionFromToday()
     * @uses PositionAreaSelection::setPosition()
     * @param float $kmsAround
     * @param string $areaType
     * @param \StructType\Identifier $driver
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \StructType\Position $position
     */
    public function __construct($kmsAround = null, $areaType = null, \StructType\Identifier $driver = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \StructType\Position $position = null)
    {
        $this
            ->setKmsAround($kmsAround)
            ->setAreaType($areaType)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setPosition($position);
    }
    /**
     * Get KmsAround value
     * @return float
     */
    public function getKmsAround()
    {
        return $this->KmsAround;
    }
    /**
     * Set KmsAround value
     * @param float $kmsAround
     * @return \StructType\PositionAreaSelection
     */
    public function setKmsAround($kmsAround = null)
    {
        // validation for constraint: float
        if (!is_null($kmsAround) && !(is_float($kmsAround) || is_numeric($kmsAround))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kmsAround, true), gettype($kmsAround)), __LINE__);
        }
        $this->KmsAround = $kmsAround;
        return $this;
    }
    /**
     * Get AreaType value
     * @return string
     */
    public function getAreaType()
    {
        return $this->AreaType;
    }
    /**
     * Set AreaType value
     * @uses \EnumType\EnumPositionAreaType::valueIsValid()
     * @uses \EnumType\EnumPositionAreaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $areaType
     * @return \StructType\PositionAreaSelection
     */
    public function setAreaType($areaType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPositionAreaType::valueIsValid($areaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPositionAreaType', is_array($areaType) ? implode(', ', $areaType) : var_export($areaType, true), implode(', ', \EnumType\EnumPositionAreaType::getValidValues())), __LINE__);
        }
        $this->AreaType = $areaType;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\PositionAreaSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\PositionAreaSelection
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PositionAreaSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\PositionAreaSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PositionAreaSelection
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
