<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningResult StructType
 * @subpackage Structs
 */
class PlanningResult extends AbstractStructBase
{
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trips
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTripResult
     */
    public $Trips;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceResult
     */
    public $Places;
    /**
     * Constructor method for PlanningResult
     * @uses PlanningResult::setDriver()
     * @uses PlanningResult::setVehicle()
     * @uses PlanningResult::setTrips()
     * @uses PlanningResult::setPlaces()
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \ArrayType\ArrayOfTripResult $trips
     * @param \ArrayType\ArrayOfPlaceResult $places
     */
    public function __construct(\StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, \ArrayType\ArrayOfTripResult $trips = null, \ArrayType\ArrayOfPlaceResult $places = null)
    {
        $this
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setTrips($trips)
            ->setPlaces($places);
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\PlanningResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\PlanningResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trips value
     * @return \ArrayType\ArrayOfTripResult|null
     */
    public function getTrips()
    {
        return $this->Trips;
    }
    /**
     * Set Trips value
     * @param \ArrayType\ArrayOfTripResult $trips
     * @return \StructType\PlanningResult
     */
    public function setTrips(\ArrayType\ArrayOfTripResult $trips = null)
    {
        $this->Trips = $trips;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceResult|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceResult $places
     * @return \StructType\PlanningResult
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceResult $places = null)
    {
        $this->Places = $places;
        return $this;
    }
}
