<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningModificationsSelection_V4 StructType
 * @subpackage Structs
 */
class PlanningModificationsSelection_V4 extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The IncludeUpdatePlanningChanges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeUpdatePlanningChanges;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for PlanningModificationsSelection_V4
     * @uses PlanningModificationsSelection_V4::setPlanningSelectionType()
     * @uses PlanningModificationsSelection_V4::setIncludeUpdatePlanningChanges()
     * @uses PlanningModificationsSelection_V4::setDateStrategySelection()
     * @param string $planningSelectionType
     * @param bool $includeUpdatePlanningChanges
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($planningSelectionType = null, $includeUpdatePlanningChanges = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setIncludeUpdatePlanningChanges($includeUpdatePlanningChanges)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningSelectionModificationsType_V2::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionModificationsType_V2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningModificationsSelection_V4
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionModificationsType_V2::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionModificationsType_V2', is_array($planningSelectionType) ? implode(', ', $planningSelectionType) : var_export($planningSelectionType, true), implode(', ', \EnumType\EnumPlanningSelectionModificationsType_V2::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get IncludeUpdatePlanningChanges value
     * @return bool
     */
    public function getIncludeUpdatePlanningChanges()
    {
        return $this->IncludeUpdatePlanningChanges;
    }
    /**
     * Set IncludeUpdatePlanningChanges value
     * @param bool $includeUpdatePlanningChanges
     * @return \StructType\PlanningModificationsSelection_V4
     */
    public function setIncludeUpdatePlanningChanges($includeUpdatePlanningChanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeUpdatePlanningChanges) && !is_bool($includeUpdatePlanningChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeUpdatePlanningChanges, true), gettype($includeUpdatePlanningChanges)), __LINE__);
        }
        $this->IncludeUpdatePlanningChanges = $includeUpdatePlanningChanges;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\PlanningModificationsSelection_V4
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
}
