<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningModificationsSelection_V2 StructType
 * @subpackage Structs
 */
class PlanningModificationsSelection_V2 extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningOptionsSelection_V2
     */
    public $Options;
    /**
     * Constructor method for PlanningModificationsSelection_V2
     * @uses PlanningModificationsSelection_V2::setPlanningSelectionType()
     * @uses PlanningModificationsSelection_V2::setDateTimeRange()
     * @uses PlanningModificationsSelection_V2::setSelectionFromToday()
     * @uses PlanningModificationsSelection_V2::setOptions()
     * @param string $planningSelectionType
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \StructType\PlanningOptionsSelection_V2 $options
     */
    public function __construct($planningSelectionType = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \StructType\PlanningOptionsSelection_V2 $options = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setOptions($options);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningSelectionModificationsType::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionModificationsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningModificationsSelection_V2
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionModificationsType::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionModificationsType', is_array($planningSelectionType) ? implode(', ', $planningSelectionType) : var_export($planningSelectionType, true), implode(', ', \EnumType\EnumPlanningSelectionModificationsType::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PlanningModificationsSelection_V2
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\PlanningModificationsSelection_V2
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get Options value
     * @return \StructType\PlanningOptionsSelection_V2|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \StructType\PlanningOptionsSelection_V2 $options
     * @return \StructType\PlanningModificationsSelection_V2
     */
    public function setOptions(\StructType\PlanningOptionsSelection_V2 $options = null)
    {
        $this->Options = $options;
        return $this;
    }
}
